/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.pablito.pBLobbyCore.listeners.BlockBreakListener;
import org.pablito.pBLobbyCore.listeners.ItemDropListener;
import org.pablito.pBLobbyCore.listeners.NoDamageListener;
import org.pablito.pBLobbyCore.utils.MessageManager;

public final class PBLobbyCore
extends JavaPlugin {
    private static PBLobbyCore plugin;

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.saveResource("messages.yml", false);
        MessageManager.loadMessages();
        boolean isItemDropEnabled = this.getConfig().getBoolean("modules.no-item-drop", true);
        boolean isBreakBlockEnabled = this.getConfig().getBoolean("modules.no-block-break", true);
        boolean isNoDamageEnabled = this.getConfig().getBoolean("modules.no-damage", true);
        if (isItemDropEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new ItemDropListener(), (Plugin)this);
        }
        if (isBreakBlockEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(), (Plugin)this);
        }
        if (isNoDamageEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new NoDamageListener(), (Plugin)this);
        }
        String version = this.getDescription().getVersion();
        this.getLogger().info("[PB-LobbyCore] PB-LobbyCorre v" + version + "plugin enabled.");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getName().equalsIgnoreCase("Pablohs08")) {
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "[Plugin-Management] Este Servidor utiliza tu Plugin: SecureCommands v" + this.getDescription().getVersion());
        }
    }

    public void onDisable() {
        this.getLogger().info("[PB-LobbyCore] PB-LobbyCore plugin disabled.");
    }

    public static PBLobbyCore getPlugin() {
        return plugin;
    }
}

