/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore;

import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.pablito.pBLobbyCore.commands.PBLobbyCoreCommand;
import org.pablito.pBLobbyCore.listeners.BlockBreakListener;
import org.pablito.pBLobbyCore.listeners.CommandBlockerListener;
import org.pablito.pBLobbyCore.listeners.ItemDropListener;
import org.pablito.pBLobbyCore.listeners.NoDamageListener;
import org.pablito.pBLobbyCore.listeners.PlayerJoinQuitListener;
import org.pablito.pBLobbyCore.utils.MessageManager;

public final class PBLobbyCore
extends JavaPlugin {
    private FileConfiguration modulesConfig;
    private MessageManager messageManager;

    public void onEnable() {
        this.setupPlugin();
        String version = this.getDescription().getVersion();
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore v" + version + " plugin enabled.");
        this.getLogger().info("[PBLobbyCore] Developed by Pablohs08");
    }

    public void onDisable() {
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore plugin disabled.");
        this.getLogger().info("[Pablito] Developed by Pablohs08");
    }

    public void reloadPluginConfigs() {
        this.reloadConfig();
        this.loadModulesConfig();
        this.setupPlugin();
    }

    private void setupPlugin() {
        this.loadAllConfigs();
        this.messageManager = new MessageManager(this);
        this.getCommand("pblcore").setExecutor((CommandExecutor)new PBLobbyCoreCommand(this, this.messageManager));
        this.loadModules();
    }

    private void loadAllConfigs() {
        this.saveDefaultConfig();
        this.loadModulesConfig();
        this.saveLanguageFiles();
    }

    private void saveLanguageFiles() {
        File enFile;
        File esFile;
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(esFile = new File(langFolder, "es.yml")).exists()) {
            this.saveResource("lang/es.yml", false);
        }
        if (!(enFile = new File(langFolder, "en.yml")).exists()) {
            this.saveResource("lang/en.yml", false);
        }
    }

    private void loadModules() {
        boolean isItemDropEnabled = this.modulesConfig.getBoolean("modules.no-item-drop", true);
        boolean isBreakBlockEnabled = this.modulesConfig.getBoolean("modules.no-block-break", true);
        boolean isNoDamageEnabled = this.modulesConfig.getBoolean("modules.no-damage", true);
        boolean isPlayerJoinQuitEnabled = this.modulesConfig.getBoolean("modules.join-quit-messages", true);
        boolean isCommandBlockerEnabled = this.modulesConfig.getBoolean("modules.command-blocker", true);
        if (isItemDropEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new ItemDropListener(this.messageManager), (Plugin)this);
        }
        if (isBreakBlockEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(this.messageManager), (Plugin)this);
        }
        if (isNoDamageEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new NoDamageListener(), (Plugin)this);
        }
        if (isPlayerJoinQuitEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinQuitListener(this.messageManager), (Plugin)this);
        }
        if (isCommandBlockerEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new CommandBlockerListener(this.getConfig(), this.messageManager), (Plugin)this);
        }
    }

    private void loadModulesConfig() {
        File modulesFile = new File(this.getDataFolder(), "modules.yml");
        if (!modulesFile.exists()) {
            this.saveResource("modules.yml", false);
        }
        this.modulesConfig = YamlConfiguration.loadConfiguration((File)modulesFile);
    }
}

