/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.pablito.pBLobbyCore.commands.LockChatCommand;
import org.pablito.pBLobbyCore.commands.PBLobbyCoreCommand;
import org.pablito.pBLobbyCore.commands.PBLobbyCoreTabCompleter;
import org.pablito.pBLobbyCore.listeners.AntiAltsListener;
import org.pablito.pBLobbyCore.listeners.BlockBreakListener;
import org.pablito.pBLobbyCore.listeners.BlockPlaceListener;
import org.pablito.pBLobbyCore.listeners.ChatLockListener;
import org.pablito.pBLobbyCore.listeners.CommandBlockerListener;
import org.pablito.pBLobbyCore.listeners.ItemDropListener;
import org.pablito.pBLobbyCore.listeners.MaintenanceListener;
import org.pablito.pBLobbyCore.listeners.MobSpawnerListener;
import org.pablito.pBLobbyCore.listeners.NoDamageListener;
import org.pablito.pBLobbyCore.listeners.PlayerJoinQuitListener;
import org.pablito.pBLobbyCore.listeners.PlugmanBlocker;
import org.pablito.pBLobbyCore.listeners.PvpListener;
import org.pablito.pBLobbyCore.listeners.ScoreboardListener;
import org.pablito.pBLobbyCore.listeners.VoidFallListener;
import org.pablito.pBLobbyCore.listeners.WhitelistListener;
import org.pablito.pBLobbyCore.utils.MessageManager;
import org.pablito.pBLobbyCore.utils.ScoreboardManager;
import org.pablito.pBLobbyCore.utils.TabManager;

public final class PBLobbyCore
extends JavaPlugin {
    private FileConfiguration modulesConfig;
    private File modulesFile;
    private FileConfiguration whitelistConfig;
    private File whitelistFile;
    private MessageManager messageManager;
    private BukkitTask maintenanceCheckerTask;
    private ScoreboardManager scoreboardManager;
    private TabManager tabManager;
    private boolean chatLocked = false;

    public void onEnable() {
        this.setupPlugin();
        this.startMaintenanceChecker();
        String version = this.getDescription().getVersion();
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore v" + version + " plugin enabled.");
        this.getLogger().info("[PBLobbyCore] Developed by Pablohs08");
    }

    public void onDisable() {
        if (this.maintenanceCheckerTask != null) {
            this.maintenanceCheckerTask.cancel();
        }
        if (this.scoreboardManager != null) {
            this.scoreboardManager.stopScoreboardUpdater();
        }
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore plugin disabled.");
        this.getLogger().info("[Pablito] Developed by Pablohs08");
    }

    public void reloadPluginConfigs() {
        this.unloadListeners();
        if (this.maintenanceCheckerTask != null) {
            this.maintenanceCheckerTask.cancel();
        }
        if (this.scoreboardManager != null) {
            this.scoreboardManager.stopScoreboardUpdater();
            this.scoreboardManager = null;
        }
        if (this.tabManager != null) {
            this.tabManager.stopTabUpdater();
            this.tabManager = null;
        }
        this.reloadConfig();
        this.loadModulesConfig();
        this.loadWhitelistConfig();
        this.setupPlugin();
        this.startMaintenanceChecker();
    }

    private void setupPlugin() {
        this.loadAllConfigs();
        this.messageManager = new MessageManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlugmanBlocker(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("pblcore")).setExecutor((CommandExecutor)new PBLobbyCoreCommand(this, this.messageManager));
        Objects.requireNonNull(this.getCommand("pblcore")).setTabCompleter((TabCompleter)new PBLobbyCoreTabCompleter(this));
        Objects.requireNonNull(this.getCommand("lock")).setExecutor((CommandExecutor)new LockChatCommand(this, this.messageManager));
        Objects.requireNonNull(this.getCommand("unlock")).setExecutor((CommandExecutor)new LockChatCommand(this, this.messageManager));
        this.loadModules();
    }

    private void startMaintenanceChecker() {
        this.maintenanceCheckerTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            boolean maintenanceMode = this.getModulesConfig().getBoolean("modules.maintenance-mode");
            if (maintenanceMode) {
                List whitelist = this.getWhitelistConfig().getStringList("players");
                String kickMessage = this.getMessageManager().getMessage("maintenance-kick-message");
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.hasPermission("pblcore.admin") || whitelist.contains(player.getName())) continue;
                    Bukkit.getScheduler().runTask((Plugin)this, () -> player.kickPlayer(kickMessage));
                }
            }
        }, 0L, 100L);
    }

    private void unloadListeners() {
        HandlerList.unregisterAll((Plugin)this);
    }

    private void loadAllConfigs() {
        this.saveDefaultConfig();
        this.loadModulesConfig();
        this.loadWhitelistConfig();
        this.saveLanguageFiles();
    }

    public void loadWhitelistConfig() {
        this.whitelistFile = new File(this.getDataFolder(), "whitelist.yml");
        if (!this.whitelistFile.exists()) {
            this.saveResource("whitelist.yml", false);
        }
        this.whitelistConfig = YamlConfiguration.loadConfiguration((File)this.whitelistFile);
    }

    public FileConfiguration getWhitelistConfig() {
        return this.whitelistConfig;
    }

    public void saveWhitelistConfig() {
        try {
            this.whitelistConfig.save(this.whitelistFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Whitelist configuration could not be saved: " + e.getMessage());
        }
    }

    private void saveLanguageFiles() {
        File ukFile;
        File ruFile;
        File prFile;
        File plFile;
        File deFile;
        File frFile;
        File enFile;
        File esFile;
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(esFile = new File(langFolder, "es.yml")).exists()) {
            this.saveResource("lang/es.yml", false);
        }
        if (!(enFile = new File(langFolder, "en.yml")).exists()) {
            this.saveResource("lang/en.yml", false);
        }
        if (!(frFile = new File(langFolder, "fr.yml")).exists()) {
            this.saveResource("lang/fr.yml", false);
        }
        if (!(deFile = new File(langFolder, "de.yml")).exists()) {
            this.saveResource("lang/de.yml", false);
        }
        if (!(plFile = new File(langFolder, "pl.yml")).exists()) {
            this.saveResource("lang/pl.yml", false);
        }
        if (!(prFile = new File(langFolder, "pr.yml")).exists()) {
            this.saveResource("lang/pr.yml", false);
        }
        if (!(ruFile = new File(langFolder, "ru.yml")).exists()) {
            this.saveResource("lang/ru.yml", false);
        }
        if (!(ukFile = new File(langFolder, "uk.yml")).exists()) {
            this.saveResource("lang/uk.yml", false);
        }
    }

    private void loadModules() {
        boolean isWhitelistEnabled = this.modulesConfig.getBoolean("modules.whitelist", false);
        boolean isItemDropEnabled = this.modulesConfig.getBoolean("modules.no-item-drop", false);
        boolean isBreakBlockEnabled = this.modulesConfig.getBoolean("modules.no-block-break", false);
        boolean isBlockPlaceEnabled = this.modulesConfig.getBoolean("modules.no-block-place", false);
        boolean isNoDamageEnabled = this.modulesConfig.getBoolean("modules.no-damage", false);
        boolean isPlayerJoinQuitEnabled = this.modulesConfig.getBoolean("modules.join-quit-messages", false);
        boolean isCommandBlockerEnabled = this.modulesConfig.getBoolean("modules.command-blocker", false);
        boolean isMobSpawnerEnabled = this.modulesConfig.getBoolean("modules.no-mobs", false);
        boolean isPvPEnabled = this.modulesConfig.getBoolean("modules.no-pvp", false);
        boolean isVoidFallTeleportEnabled = this.modulesConfig.getBoolean("modules.void-fall-teleport", false);
        boolean isAltsEnabled = this.modulesConfig.getBoolean("modules.alt", false);
        boolean isMaintenanceModeEnabled = this.modulesConfig.getBoolean("modules.maintenance-mode", false);
        boolean isScoreboardEnabled = this.modulesConfig.getBoolean("modules.scoreboard", false);
        boolean isTabEnabled = this.modulesConfig.getBoolean("modules.tab", false);
        boolean isChatLockEnabled = this.modulesConfig.getBoolean("modules.chat-lock", false);
        if (isWhitelistEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new WhitelistListener(this, this.messageManager), (Plugin)this);
        }
        if (isItemDropEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new ItemDropListener(this.messageManager), (Plugin)this);
        }
        if (isBreakBlockEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(this.messageManager, this), (Plugin)this);
        }
        if (isBlockPlaceEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(this.messageManager, this), (Plugin)this);
        }
        if (isNoDamageEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new NoDamageListener(), (Plugin)this);
        }
        if (isPlayerJoinQuitEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinQuitListener(this.messageManager), (Plugin)this);
        }
        if (isCommandBlockerEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new CommandBlockerListener(this.getConfig(), this.messageManager), (Plugin)this);
        }
        if (isMobSpawnerEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new MobSpawnerListener(), (Plugin)this);
        }
        if (isPvPEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PvpListener(this.messageManager, this.getConfig()), (Plugin)this);
        }
        if (isVoidFallTeleportEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new VoidFallListener(this, this.messageManager), (Plugin)this);
        }
        if (isAltsEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new AntiAltsListener(this, this.messageManager), (Plugin)this);
        }
        if (isMaintenanceModeEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new MaintenanceListener(this), (Plugin)this);
        }
        if (isScoreboardEnabled) {
            if (!this.getConfig().contains("scoreboard")) {
                this.getLogger().severe("The Scoreboard module is enabled, but the configuration was not found in config.yml. Please check your file!");
            } else {
                this.scoreboardManager = new ScoreboardManager(this);
                this.getServer().getPluginManager().registerEvents((Listener)new ScoreboardListener(this, this.scoreboardManager), (Plugin)this);
                this.scoreboardManager.startScoreboardUpdater();
            }
        }
        if (isTabEnabled) {
            this.tabManager = new TabManager(this);
            this.tabManager.startTabUpdater();
        }
        if (isChatLockEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChatLockListener(this, this.messageManager), (Plugin)this);
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public void saveSpawnLocation(Location location) {
        FileConfiguration config = this.getConfig();
        config.set("spawn.world", (Object)location.getWorld().getName());
        config.set("spawn.x", (Object)location.getX());
        config.set("spawn.y", (Object)location.getY());
        config.set("spawn.z", (Object)location.getZ());
        config.set("spawn.yaw", (Object)Float.valueOf(location.getYaw()));
        config.set("spawn.pitch", (Object)Float.valueOf(location.getPitch()));
        this.saveConfig();
    }

    public Location getSpawnLocation() {
        FileConfiguration config = this.getConfig();
        if (!config.contains("spawn.world")) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)config.getString("spawn.world")), config.getDouble("spawn.x"), config.getDouble("spawn.y"), config.getDouble("spawn.z"), (float)config.getDouble("spawn.yaw"), (float)config.getDouble("spawn.pitch"));
    }

    public FileConfiguration getModulesConfig() {
        return this.modulesConfig;
    }

    public void saveModulesConfig() {
        try {
            this.modulesConfig.save(this.modulesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("The modules file could not be saved: " + e.getMessage());
        }
    }

    private void loadModulesConfig() {
        this.modulesFile = new File(this.getDataFolder(), "modules.yml");
        if (!this.modulesFile.exists()) {
            this.saveResource("modules.yml", false);
        }
        this.modulesConfig = YamlConfiguration.loadConfiguration((File)this.modulesFile);
    }

    public void saveDefaultConfig() {
        super.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        if (!config.contains("alt-ip-exceptions")) {
            config.set("alt-ip-exceptions", new ArrayList());
            this.saveConfig();
        }
    }

    public boolean isChatLocked() {
        return this.chatLocked;
    }

    public void setChatLocked(boolean chatLocked) {
        this.chatLocked = chatLocked;
    }
}

