/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.pablito.pBLobbyCore.PBLobbyCore;
import org.pablito.pBLobbyCore.commands.ReloadManager;
import org.pablito.pBLobbyCore.utils.MessageManager;

public class PBLobbyCoreCommand
implements CommandExecutor {
    private final PBLobbyCore plugin;
    private final MessageManager messageManager;
    private final ReloadManager reloadManager;

    public PBLobbyCoreCommand(PBLobbyCore plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.reloadManager = new ReloadManager(plugin, messageManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.messageManager.getMessage("command-usage"));
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("reload")) {
            if (!sender.hasPermission("pblcore.admin")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            this.reloadManager.reloadPlugin();
            sender.sendMessage(this.messageManager.getMessage("plugin-reloaded"));
            return true;
        }
        if (subCommand.equals("setspawn")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.messageManager.getMessage("no-console-command"));
                return true;
            }
            if (!sender.hasPermission("pblcore.admin")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            Player player = (Player)sender;
            this.plugin.saveSpawnLocation(player.getLocation());
            player.sendMessage(this.messageManager.getMessage("spawn-set"));
            return true;
        }
        if (subCommand.equals("alt")) {
            if (!sender.hasPermission("pblcore.admin")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            if (args.length < 3) {
                sender.sendMessage(this.messageManager.getMessage("alt-usage"));
                return true;
            }
            String altSubCommand = args[1];
            String ipAddress = args[2];
            if (!ipAddress.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}")) {
                sender.sendMessage(this.messageManager.getMessage("alt-invalid-ip"));
                return true;
            }
            List exceptions = this.plugin.getConfig().getStringList("alt-ip-exceptions");
            if (altSubCommand.equalsIgnoreCase("add")) {
                if (exceptions.contains(ipAddress)) {
                    sender.sendMessage(this.messageManager.getMessage("alt-ip-already-added"));
                    return true;
                }
                exceptions.add(ipAddress);
                this.plugin.getConfig().set("alt-ip-exceptions", (Object)exceptions);
                this.plugin.saveConfig();
                sender.sendMessage(this.messageManager.getMessage("alt-ip-added").replace("%ip_address%", ipAddress));
                return true;
            }
            if (altSubCommand.equalsIgnoreCase("remove")) {
                if (!exceptions.contains(ipAddress)) {
                    sender.sendMessage(this.messageManager.getMessage("alt-ip-not-in-list"));
                    return true;
                }
                exceptions.remove(ipAddress);
                this.plugin.getConfig().set("alt-ip-exceptions", (Object)exceptions);
                this.plugin.saveConfig();
                sender.sendMessage(this.messageManager.getMessage("alt-ip-removed").replace("%ip_address%", ipAddress));
                sender.sendMessage(this.messageManager.getMessage("alt-ip-removed-recheck").replace("%ip_address%", ipAddress));
                ArrayList<Player> playersWithSameIp = new ArrayList<Player>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.getAddress() == null || !p.getAddress().getAddress().getHostAddress().equals(ipAddress)) continue;
                    playersWithSameIp.add(p);
                }
                if (playersWithSameIp.size() > 1) {
                    Player mainPlayer = (Player)playersWithSameIp.get(0);
                    String kickMessage = this.messageManager.getMessage("kick-message-same-ip").replace("%player_name%", mainPlayer.getName());
                    for (int i = 1; i < playersWithSameIp.size(); ++i) {
                        Player altPlayer = (Player)playersWithSameIp.get(i);
                        altPlayer.kickPlayer(kickMessage);
                    }
                }
                return true;
            }
            sender.sendMessage(this.messageManager.getMessage("alt-usage"));
            return true;
        }
        if (subCommand.equals("maintenance")) {
            boolean newState;
            if (!this.plugin.getModulesConfig().getBoolean("modules.maintenance-mode")) {
                sender.sendMessage(this.messageManager.getMessage("module-disabled"));
                return true;
            }
            if (!sender.hasPermission("pblcore.admin")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage(this.messageManager.getMessage("maintenance-usage"));
                return true;
            }
            if (args[1].equalsIgnoreCase("on")) {
                newState = true;
                sender.sendMessage(this.messageManager.getMessage("maintenance-on"));
            } else if (args[1].equalsIgnoreCase("off")) {
                newState = false;
                sender.sendMessage(this.messageManager.getMessage("maintenance-off"));
            } else {
                sender.sendMessage(this.messageManager.getMessage("maintenance-usage"));
                return true;
            }
            this.plugin.getModulesConfig().set("modules.maintenance-mode", (Object)newState);
            this.plugin.saveModulesConfig();
            return true;
        }
        if (subCommand.equals("lock") || subCommand.equals("unlock")) {
            if (!this.plugin.getModulesConfig().getBoolean("modules.chat-lock")) {
                sender.sendMessage(this.messageManager.getMessage("module-disabled"));
                return true;
            }
            if (!sender.hasPermission("pblcore.chatlock.use")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            boolean newState = subCommand.equals("lock");
            this.plugin.setChatLocked(newState);
            if (newState) {
                sender.sendMessage(this.messageManager.getMessage("chat-locked-enabled"));
            } else {
                sender.sendMessage(this.messageManager.getMessage("chat-locked-disabled"));
            }
            return true;
        }
        sender.sendMessage(this.messageManager.getMessage("command-usage"));
        return true;
    }
}

