/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.utils;

import java.util.List;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.pablito.pBLobbyCore.PBLobbyCore;

public class TabManager {
    private final PBLobbyCore plugin;
    private BukkitTask updateTask;

    public TabManager(PBLobbyCore plugin) {
        this.plugin = plugin;
    }

    public void startTabUpdater() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        long updateInterval = this.plugin.getConfig().getLong("tab.update-interval", 20L);
        this.updateTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updatePlayerTab(player);
            }
        }, 0L, updateInterval);
    }

    public void stopTabUpdater() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }

    public void updatePlayerTab(Player player) {
        if (!this.plugin.getModulesConfig().getBoolean("modules.tab")) {
            return;
        }
        List headerLines = this.plugin.getConfig().getStringList("tab.tab-header");
        List footerLines = this.plugin.getConfig().getStringList("tab.tab-footer");
        String header = this.formatLines(headerLines, player);
        String footer = this.formatLines(footerLines, player);
        try {
            player.setPlayerListHeader(header);
            player.setPlayerListFooter(footer);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error al actualizar el TAB: " + e.getMessage());
        }
    }

    private String formatLines(List<String> lines, Player player) {
        String fullString = lines.stream().collect(Collectors.joining("\n"));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            fullString = PlaceholderAPI.setPlaceholders((Player)player, (String)fullString);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)fullString);
    }
}

