/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore;

import java.io.File;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.pablito.pBLobbyCore.commands.PBLobbyCoreCommand;
import org.pablito.pBLobbyCore.listeners.BlockBreakListener;
import org.pablito.pBLobbyCore.listeners.BlockPlaceListener;
import org.pablito.pBLobbyCore.listeners.CommandBlockerListener;
import org.pablito.pBLobbyCore.listeners.ItemDropListener;
import org.pablito.pBLobbyCore.listeners.MobSpawnerListener;
import org.pablito.pBLobbyCore.listeners.NoDamageListener;
import org.pablito.pBLobbyCore.listeners.PlayerJoinQuitListener;
import org.pablito.pBLobbyCore.listeners.PlugmanBlocker;
import org.pablito.pBLobbyCore.listeners.PvpListener;
import org.pablito.pBLobbyCore.listeners.VoidFallListener;
import org.pablito.pBLobbyCore.listeners.WhitelistListener;
import org.pablito.pBLobbyCore.utils.MessageManager;

public final class PBLobbyCore
extends JavaPlugin {
    private FileConfiguration modulesConfig;
    private FileConfiguration whitelistConfig;
    private MessageManager messageManager;

    public void onEnable() {
        this.setupPlugin();
        String version = this.getDescription().getVersion();
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore v" + version + " plugin enabled.");
        this.getLogger().info("[PBLobbyCore] Developed by Pablohs08");
    }

    public void onDisable() {
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore plugin disabled.");
        this.getLogger().info("[Pablito] Developed by Pablohs08");
    }

    public void reloadPluginConfigs() {
        this.unloadListeners();
        this.reloadConfig();
        this.loadModulesConfig();
        this.setupPlugin();
    }

    private void setupPlugin() {
        this.loadAllConfigs();
        this.messageManager = new MessageManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlugmanBlocker(this), (Plugin)this);
        Objects.requireNonNull(this.getCommand("pblcore")).setExecutor((CommandExecutor)new PBLobbyCoreCommand(this, this.messageManager));
        this.loadModules();
    }

    private void unloadListeners() {
        HandlerList.unregisterAll((Plugin)this);
    }

    private void loadAllConfigs() {
        this.saveDefaultConfig();
        this.loadModulesConfig();
        this.loadWhitelistConfig();
        this.saveLanguageFiles();
    }

    public void loadWhitelistConfig() {
        File whitelistFile = new File(this.getDataFolder(), "whitelist.yml");
        if (!whitelistFile.exists()) {
            this.saveResource("whitelist.yml", false);
        }
    }

    public FileConfiguration getWhitelistConfig() {
        return this.whitelistConfig;
    }

    private void saveLanguageFiles() {
        File plFile;
        File deFile;
        File frFile;
        File enFile;
        File esFile;
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(esFile = new File(langFolder, "es.yml")).exists()) {
            this.saveResource("lang/es.yml", false);
        }
        if (!(enFile = new File(langFolder, "en.yml")).exists()) {
            this.saveResource("lang/en.yml", false);
        }
        if (!(frFile = new File(langFolder, "fr.yml")).exists()) {
            this.saveResource("lang/fr.yml", false);
        }
        if (!(deFile = new File(langFolder, "de.yml")).exists()) {
            this.saveResource("lang/de.yml", false);
        }
        if (!(plFile = new File(langFolder, "pl.yml")).exists()) {
            this.saveResource("lang/pl.yml", false);
        }
    }

    private void loadModules() {
        boolean isWhitelistEnabled = this.modulesConfig.getBoolean("modules.whitelist", true);
        boolean isItemDropEnabled = this.modulesConfig.getBoolean("modules.no-item-drop", true);
        boolean isBreakBlockEnabled = this.modulesConfig.getBoolean("modules.no-block-break", true);
        boolean isBlockPlaceEnabled = this.modulesConfig.getBoolean("modules.no-block-place", true);
        boolean isNoDamageEnabled = this.modulesConfig.getBoolean("modules.no-damage", true);
        boolean isPlayerJoinQuitEnabled = this.modulesConfig.getBoolean("modules.join-quit-messages", true);
        boolean isCommandBlockerEnabled = this.modulesConfig.getBoolean("modules.command-blocker", true);
        boolean isMobSpawnerEnabled = this.modulesConfig.getBoolean("modules.no-mobs", true);
        boolean isPvPEnabled = this.modulesConfig.getBoolean("modules.no-pvp", true);
        boolean isVoidFallTeleportEnabled = this.modulesConfig.getBoolean("modules.void-fall-teleport", true);
        if (isWhitelistEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new WhitelistListener(this, this.messageManager), (Plugin)this);
        }
        if (isItemDropEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new ItemDropListener(this.messageManager), (Plugin)this);
        }
        if (isBreakBlockEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(this.messageManager, this), (Plugin)this);
        }
        if (isBlockPlaceEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(this.messageManager, this), (Plugin)this);
        }
        if (isNoDamageEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new NoDamageListener(), (Plugin)this);
        }
        if (isPlayerJoinQuitEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinQuitListener(this.messageManager), (Plugin)this);
        }
        if (isCommandBlockerEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new CommandBlockerListener(this.getConfig(), this.messageManager), (Plugin)this);
        }
        if (isMobSpawnerEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new MobSpawnerListener(), (Plugin)this);
        }
        if (isPvPEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PvpListener(this.messageManager, this.getConfig()), (Plugin)this);
        }
        if (isVoidFallTeleportEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new VoidFallListener(this, this.messageManager), (Plugin)this);
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public void saveSpawnLocation(Location location) {
        FileConfiguration config = this.getConfig();
        config.set("spawn.world", (Object)location.getWorld().getName());
        config.set("spawn.x", (Object)location.getX());
        config.set("spawn.y", (Object)location.getY());
        config.set("spawn.z", (Object)location.getZ());
        config.set("spawn.yaw", (Object)Float.valueOf(location.getYaw()));
        config.set("spawn.pitch", (Object)Float.valueOf(location.getPitch()));
        this.saveConfig();
    }

    public Location getSpawnLocation() {
        FileConfiguration config = this.getConfig();
        if (!config.contains("spawn.world")) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)config.getString("spawn.world")), config.getDouble("spawn.x"), config.getDouble("spawn.y"), config.getDouble("spawn.z"), (float)config.getDouble("spawn.yaw"), (float)config.getDouble("spawn.pitch"));
    }

    private void loadModulesConfig() {
        File modulesFile = new File(this.getDataFolder(), "modules.yml");
        if (!modulesFile.exists()) {
            this.saveResource("modules.yml", false);
        }
        this.modulesConfig = YamlConfiguration.loadConfiguration((File)modulesFile);
    }
}

