/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.pablito.pBLobbyCore.listeners.BlockBreakListener;
import org.pablito.pBLobbyCore.listeners.CommandBlockerListener;
import org.pablito.pBLobbyCore.listeners.ItemDropListener;
import org.pablito.pBLobbyCore.listeners.NoDamageListener;
import org.pablito.pBLobbyCore.listeners.PlayerJoinQuitListener;
import org.pablito.pBLobbyCore.utils.MessageManager;

public final class PBLobbyCore
extends JavaPlugin {
    private FileConfiguration modulesConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadModulesConfig();
        MessageManager messageManager = new MessageManager(this);
        boolean isItemDropEnabled = this.modulesConfig.getBoolean("modules.no-item-drop", true);
        boolean isBreakBlockEnabled = this.modulesConfig.getBoolean("modules.no-block-break", true);
        boolean isNoDamageEnabled = this.modulesConfig.getBoolean("modules.no-damage", true);
        boolean isPlayerJoinQuitEnabled = this.modulesConfig.getBoolean("modules.join-quit-messages", true);
        boolean isCommandBlockerEnabled = this.modulesConfig.getBoolean("modules.command-blocker", true);
        if (isItemDropEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new ItemDropListener(messageManager), (Plugin)this);
        }
        if (isBreakBlockEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(messageManager), (Plugin)this);
        }
        if (isNoDamageEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new NoDamageListener(), (Plugin)this);
        }
        if (isPlayerJoinQuitEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinQuitListener(messageManager), (Plugin)this);
        }
        if (isCommandBlockerEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new CommandBlockerListener(this.getConfig(), messageManager), (Plugin)this);
        }
        String version = this.getDescription().getVersion();
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore v" + version + " plugin enabled.");
        this.getLogger().info("[PBLobbyCore] Developed by Pablohs08");
    }

    private void loadModulesConfig() {
        File modulesFile = new File(this.getDataFolder(), "modules.yml");
        if (!modulesFile.exists()) {
            this.saveResource("modules.yml", false);
        }
        this.modulesConfig = YamlConfiguration.loadConfiguration((File)modulesFile);
    }

    public void onDisable() {
        this.getLogger().info("[PBLobbyCore] PB-LobbyCore plugin disabled.");
        this.getLogger().info("[PBLobbyCore] Developed by Pablohs08");
    }
}

