/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.utils;

import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private String prefix;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        this.plugin.saveResource("messages.yml", false);
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagesConfig.getString("prefix", "&8[&9PBLobby&8] &7"));
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString("messages." + path);
        if (message == null) {
            return String.valueOf(ChatColor.RED) + "Error: Message not found for path '" + path + "'";
        }
        String finalMessage = message.replace("%prefix%", this.prefix);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)finalMessage);
    }

    public String getJoinMessage(String playerName) {
        String message = this.messagesConfig.getString("messages.join_message", "&a[+] &f%player%");
        message = message.replace("%player%", playerName);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getQuitMessage(String playerName) {
        String message = this.messagesConfig.getString("messages.quit_message", "&c[-] &f%player%");
        message = message.replace("%player%", playerName);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

