/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.utils;

import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageManager {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private String prefix;

    public MessageManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        String language = this.plugin.getConfig().getString("language", "en");
        File langFile = new File(this.plugin.getDataFolder(), "lang" + File.separator + language + ".yml");
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)langFile);
        this.prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagesConfig.getString("prefix", ""));
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString("messages." + path);
        if (message == null) {
            return String.valueOf(ChatColor.RED) + "Error: Message not found for path '" + path + "'";
        }
        String finalMessage = message.replace("%prefix%", this.prefix);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)finalMessage);
    }
}

