/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.utils;

import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.pablito.pBLobbyCore.PBLobbyCore;

public class ScoreboardManager {
    private final PBLobbyCore plugin;
    private BukkitTask updateTask;

    public ScoreboardManager(PBLobbyCore plugin) {
        this.plugin = plugin;
    }

    public void startScoreboardUpdater() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        long updateInterval = this.plugin.getConfig().getLong("scoreboard.update-interval", 20L);
        this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.updateScoreboard(player);
            }
        }, 0L, updateInterval);
    }

    public void stopScoreboardUpdater() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
    }

    public void updateScoreboard(Player player) {
        if (!this.plugin.getModulesConfig().getBoolean("modules.scoreboard")) {
            this.removeScoreboard(player);
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        Objective objective = scoreboard.getObjective(DisplaySlot.SIDEBAR);
        if (objective == null || !objective.getName().equals("pblcore_scoreboard")) {
            this.createScoreboard(player);
            scoreboard = player.getScoreboard();
            objective = scoreboard.getObjective(DisplaySlot.SIDEBAR);
        }
        String newTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("scoreboard.title", "Scoreboard"));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            newTitle = PlaceholderAPI.setPlaceholders((Player)player, (String)newTitle);
        }
        objective.setDisplayName(newTitle);
        for (String entry : scoreboard.getEntries()) {
            scoreboard.resetScores(entry);
        }
        List lines = this.plugin.getConfig().getStringList("scoreboard.lines");
        int blankLineCounter = 0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            Object processedLine = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
            if (((String)processedLine).trim().isEmpty()) {
                processedLine = ChatColor.RESET.toString() + String.valueOf(ChatColor.values()[blankLineCounter]);
                ++blankLineCounter;
            } else if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                processedLine = PlaceholderAPI.setPlaceholders((Player)player, (String)processedLine);
            }
            if (((String)processedLine).length() > 40) {
                processedLine = ((String)processedLine).substring(0, 40);
            }
            objective.getScore((String)processedLine).setScore(lines.size() - i);
        }
    }

    public void createScoreboard(Player player) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("scoreboard.title", "Scoreboard"));
        Objective objective = scoreboard.registerNewObjective("pblcore_scoreboard", "dummy", title);
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        player.setScoreboard(scoreboard);
    }

    public void removeScoreboard(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }
}

