/*
 * Decompiled with CFR 0.152.
 */
package dev.kiddo.animalinfo.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1440;
import net.minecraft.class_1495;
import net.minecraft.class_1498;
import net.minecraft.class_1500;
import net.minecraft.class_1501;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

public class AnimalInfoCommandHandler {
    private static final Map<String, String> entityColorMap = new HashMap<String, String>();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"animalinfo").executes(context -> {
            class_1297 entity;
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_1297 selector0$temp = entity = source.getClient().field_1692;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1495.class, class_1500.class, class_1498.class, class_1501.class, class_1440.class, class_1506.class, class_1507.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    class_1495 donkey = (class_1495)selector0$temp;
                    class_5250 movementSpeedValue = AnimalInfoCommandHandler.getMovementSpeed((class_1309)donkey);
                    class_5250 jumpHeightValue = AnimalInfoCommandHandler.getJumpHeight((class_1309)donkey);
                    class_5250 healthValue = AnimalInfoCommandHandler.getHealthValue((class_1309)donkey);
                    class_5250 message = AnimalInfoCommandHandler.formatText(healthValue, jumpHeightValue, movementSpeedValue, null, null, null, null, null);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Donkey", message);
                    return 1;
                }
                case 1: {
                    class_1500 mule = (class_1500)selector0$temp;
                    class_5250 movementSpeedValue = AnimalInfoCommandHandler.getMovementSpeed((class_1309)mule);
                    class_5250 jumpHeightValue = AnimalInfoCommandHandler.getJumpHeight((class_1309)mule);
                    class_5250 healthValue = AnimalInfoCommandHandler.getHealthValue((class_1309)mule);
                    class_5250 message = AnimalInfoCommandHandler.formatText(healthValue, jumpHeightValue, movementSpeedValue, null, null, null, null, null);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Mule", message);
                    return 1;
                }
                case 2: {
                    class_1498 horse = (class_1498)selector0$temp;
                    class_5250 movementSpeedValue = AnimalInfoCommandHandler.getMovementSpeed((class_1309)horse);
                    class_5250 jumpHeightValue = AnimalInfoCommandHandler.getJumpHeight((class_1309)horse);
                    class_5250 healthValue = AnimalInfoCommandHandler.getHealthValue((class_1309)horse);
                    class_5250 patternVariantValue = class_2561.method_43470((String)entityColorMap.get(horse.method_27078().name().toLowerCase())).method_27694(style -> style.method_10977(class_124.field_1076));
                    class_5250 horseColorValue = class_2561.method_43470((String)entityColorMap.get(horse.method_27077().name().toLowerCase())).method_27694(style -> style.method_10977(class_124.field_1078));
                    class_5250 message = AnimalInfoCommandHandler.formatText(healthValue, jumpHeightValue, movementSpeedValue, patternVariantValue, horseColorValue, null, null, null);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Horse", message);
                    return 1;
                }
                case 3: {
                    class_1501 llama = (class_1501)selector0$temp;
                    class_5250 healthValue = AnimalInfoCommandHandler.getHealthValue((class_1309)llama);
                    class_5250 llamaColorValue = class_2561.method_43470((String)entityColorMap.get(llama.method_6809().name().toLowerCase())).method_27694(style -> style.method_10977(class_124.field_1078));
                    class_5250 llamaStrengthValue = class_2561.method_43470((String)String.valueOf(llama.method_6803())).method_27694(style -> style.method_10977(class_124.field_1075));
                    class_5250 message = AnimalInfoCommandHandler.formatText(healthValue, null, null, null, llamaColorValue, llamaStrengthValue, null, null);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Llama", message);
                    return 1;
                }
                case 4: {
                    class_1440 panda = (class_1440)selector0$temp;
                    class_1440.class_1443 mainGene = panda.method_6525();
                    class_1440.class_1443 hiddenGene = panda.method_6508();
                    String mainGeneRecessive = mainGene.method_6568() ? "(recessive)" : "(dominant)";
                    String hiddenGeneRecessive = hiddenGene.method_6568() ? "(recessive)" : "(dominant)";
                    class_5250 mainGeneValue = class_2561.method_43470((String)(panda.method_6525().method_15434().toLowerCase() + " " + mainGeneRecessive)).method_27694(style -> style.method_27703(class_5251.method_27717((int)368810)));
                    class_5250 hiddenGeneValue = class_2561.method_43470((String)(panda.method_6508().method_15434().toLowerCase() + " " + hiddenGeneRecessive)).method_27694(style -> style.method_27703(class_5251.method_27717((int)368810)));
                    class_5250 message = AnimalInfoCommandHandler.formatText(null, null, null, null, null, null, hiddenGeneValue, mainGeneValue);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Panda", message);
                    return 1;
                }
                case 5: {
                    class_1506 skeletonHorse = (class_1506)selector0$temp;
                    class_5250 movementSpeedValue = AnimalInfoCommandHandler.getMovementSpeed((class_1309)skeletonHorse);
                    class_5250 jumpHeightValue = AnimalInfoCommandHandler.getJumpHeight((class_1309)skeletonHorse);
                    class_5250 healthValue = AnimalInfoCommandHandler.getHealthValue((class_1309)skeletonHorse);
                    class_5250 message = AnimalInfoCommandHandler.formatText(healthValue, jumpHeightValue, movementSpeedValue, null, null, null, null, null);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Skeleton Horse", message);
                    return 1;
                }
                case 6: {
                    class_1507 zombieHorse = (class_1507)selector0$temp;
                    class_5250 movementSpeedValue = AnimalInfoCommandHandler.getMovementSpeed((class_1309)zombieHorse);
                    class_5250 jumpHeightValue = AnimalInfoCommandHandler.getJumpHeight((class_1309)zombieHorse);
                    class_5250 healthValue = AnimalInfoCommandHandler.getHealthValue((class_1309)zombieHorse);
                    class_5250 message = AnimalInfoCommandHandler.formatText(healthValue, jumpHeightValue, movementSpeedValue, null, null, null, null, null);
                    AnimalInfoCommandHandler.sendInfoMessage(source, "Zombie Horse", message);
                    return 1;
                }
            }
            AnimalInfoCommandHandler.sendInvalidEntityMessage(source);
            return 0;
        }));
    }

    private static void sendInvalidEntityMessage(FabricClientCommandSource source) {
        class_5250 message = class_2561.method_43470((String)"No valid entity selected or not an animal").method_27694(style -> style.method_27703(class_5251.method_27717((int)0xFF0000)));
        source.sendFeedback((class_2561)message);
    }

    private static void sendInfoMessage(FabricClientCommandSource source, String entity, class_5250 message) {
        class_5250 baseText = class_2561.method_43470((String)(entity + " Information")).method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 comma = class_2561.method_43470((String)": ").method_27694(style -> style.method_10977(class_124.field_1068));
        source.sendFeedback((class_2561)baseText.method_10852((class_2561)comma).method_10852((class_2561)message));
    }

    public static class_5250 getMovementSpeed(class_1309 entity) {
        DecimalFormat df = new DecimalFormat("#.###");
        double baseValue = entity.method_45326(class_5134.field_23719);
        String formattedSpeed = df.format(baseValue * 42.1629629629629);
        return class_2561.method_43470((String)formattedSpeed).method_27694(style -> style.method_27703(class_5251.method_27717((int)7977708)));
    }

    public static class_5250 getJumpHeight(class_1309 entity) {
        DecimalFormat df = new DecimalFormat("#.###");
        double baseValue = entity.method_45326(class_5134.field_23728);
        double convertedValue = -0.1817584952 * baseValue * baseValue * baseValue + 3.689713992 * baseValue * baseValue + 2.128599134 * baseValue - 0.343930367;
        String formattedHeight = df.format(convertedValue);
        return class_2561.method_43470((String)formattedHeight).method_27694(style -> style.method_27703(class_5251.method_27717((int)5101174)));
    }

    public static class_5250 getHealthValue(class_1309 entity) {
        DecimalFormat df = new DecimalFormat("#.###");
        double baseValue = entity.method_6063();
        String formattedHealth = df.format(baseValue);
        return class_2561.method_43470((String)formattedHealth).method_27694(style -> style.method_10977(class_124.field_1061));
    }

    public static class_5250 formatText(class_5250 healthValue, class_5250 jumpHeightValue, class_5250 movementSpeedValue, class_5250 patternVariantValue, class_5250 colorValue, class_5250 strengthValue, class_5250 hiddenGene, class_5250 mainGene) {
        class_5250 colonChar = class_2561.method_43470((String)": ").method_27694(style -> style.method_10977(class_124.field_1068));
        class_5250 healthMessage = class_2561.method_43470((String)"\nHealth").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 jumpHeightMessage = class_2561.method_43470((String)"\nJump Height").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 movementSpeedMessage = class_2561.method_43470((String)"\nSpeed").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 patternVariantMessage = class_2561.method_43470((String)"\nPattern Variant").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 colorMessage = class_2561.method_43470((String)"\nColor").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 strengthMessage = class_2561.method_43470((String)"\nStrength").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 hiddenGeneMessage = class_2561.method_43470((String)"\nHidden Gene").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 mainGeneMessage = class_2561.method_43470((String)"\nMain Gene").method_27694(style -> style.method_27703(class_5251.method_27717((int)268216320)));
        class_5250 message = class_2561.method_43473();
        if (movementSpeedValue != null) {
            message.method_10852((class_2561)movementSpeedMessage).method_10852((class_2561)colonChar).method_10852((class_2561)movementSpeedValue);
        }
        if (jumpHeightValue != null) {
            message.method_10852((class_2561)jumpHeightMessage).method_10852((class_2561)colonChar).method_10852((class_2561)jumpHeightValue);
        }
        if (healthValue != null) {
            message.method_10852((class_2561)healthMessage).method_10852((class_2561)colonChar).method_10852((class_2561)healthValue);
        }
        if (patternVariantValue != null) {
            message.method_10852((class_2561)patternVariantMessage).method_10852((class_2561)colonChar).method_10852((class_2561)patternVariantValue);
        }
        if (colorValue != null) {
            message.method_10852((class_2561)colorMessage).method_10852((class_2561)colonChar).method_10852((class_2561)colorValue);
        }
        if (strengthValue != null) {
            message.method_10852((class_2561)strengthMessage).method_10852((class_2561)colonChar).method_10852((class_2561)strengthValue);
        }
        if (mainGene != null) {
            message.method_10852((class_2561)mainGeneMessage).method_10852((class_2561)colonChar).method_10852((class_2561)mainGene);
        }
        if (hiddenGene != null) {
            message.method_10852((class_2561)hiddenGeneMessage).method_10852((class_2561)colonChar).method_10852((class_2561)hiddenGene);
        }
        return message;
    }

    static {
        entityColorMap.put("white_field", "Whitefield");
        entityColorMap.put("white_dots", "White Spots");
        entityColorMap.put("black_dots", "Black Dots");
        entityColorMap.put("white", "White");
        entityColorMap.put("none", "Plain");
        entityColorMap.put("dark_brown", "Dark Brown");
        entityColorMap.put("chestnut", "Chestnut");
        entityColorMap.put("brown", "Brown");
        entityColorMap.put("black", "Black");
        entityColorMap.put("gray", "Gray");
        entityColorMap.put("creamy", "Creamy");
    }
}

