/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.deserializer;

import java.io.IOException;
import me.whereareiam.socialismus.api.Constants;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.core.JsonParser;
import me.whereareiam.socialismus.library.jackson.databind.DeserializationContext;
import me.whereareiam.socialismus.library.jackson.databind.JsonDeserializer;
import me.whereareiam.socialismus.library.jackson.databind.JsonNode;

@Singleton
public class VersionDeserializer
extends JsonDeserializer<Version> {
    private final PlatformInteractor interactor;

    @Inject
    public VersionDeserializer(PlatformInteractor interactor) {
        this.interactor = interactor;
    }

    public Version deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        String value = node.asText();
        if (value.equals(Version.UNSUPPORTED.toString())) {
            throw new IOException("Unsupported version: " + value);
        }
        if ("ALL".equalsIgnoreCase(value)) {
            return Constants.SERVER_VERSION;
        }
        try {
            return Version.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid version value: " + value, e);
        }
    }
}

