/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.management;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import lombok.Generated;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationMerger;
import me.whereareiam.socialismus.adapter.config.management.DefaultConfigurationSaver;
import me.whereareiam.socialismus.api.exception.ConfigLoadException;
import me.whereareiam.socialismus.api.output.config.ConfigurationLoader;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.databind.ObjectMapper;

@Singleton
public class DefaultConfigurationLoader
implements ConfigurationLoader {
    private final ConfigurationManager configManager;
    private final ObjectMapper objectMapper;
    private final DefaultConfigurationSaver defaultConfigurationSaver;
    private final DefaultConfigurationMerger defaultConfigurationMerger;

    @Override
    public <T> T load(Path path, Class<T> clazz) {
        Object config;
        path = path.resolveSibling(String.valueOf(path.getFileName()) + this.configManager.getConfigurationType().getExtension());
        try {
            config = this.objectMapper.readValue(path.toFile(), clazz);
        }
        catch (FileNotFoundException e) {
            config = this.configManager.getTemplate(clazz).getDefault();
            this.defaultConfigurationSaver.save(path, config);
        }
        catch (Exception e) {
            throw new ConfigLoadException("Failed to load configuration", e);
        }
        T defaultConfig = this.configManager.getTemplate(clazz).getDefault();
        this.defaultConfigurationMerger.merge(config, defaultConfig);
        this.defaultConfigurationSaver.save(path, config);
        return (T)config;
    }

    @Override
    public <T> T load(InputStream stream, Class<T> clazz) {
        Object config;
        try {
            config = this.objectMapper.readValue(stream, clazz);
        }
        catch (Exception e) {
            throw new ConfigLoadException("Failed to load configuration", e);
        }
        return (T)config;
    }

    @Generated
    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public DefaultConfigurationSaver getDefaultConfigurationSaver() {
        return this.defaultConfigurationSaver;
    }

    @Generated
    public DefaultConfigurationMerger getDefaultConfigurationMerger() {
        return this.defaultConfigurationMerger;
    }

    @Inject
    @Generated
    public DefaultConfigurationLoader(ConfigurationManager configManager, ObjectMapper objectMapper, DefaultConfigurationSaver defaultConfigurationSaver, DefaultConfigurationMerger defaultConfigurationMerger) {
        this.configManager = configManager;
        this.objectMapper = objectMapper;
        this.defaultConfigurationSaver = defaultConfigurationSaver;
        this.defaultConfigurationMerger = defaultConfigurationMerger;
    }
}

