/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider.base;

import java.util.Set;
import lombok.Generated;
import me.whereareiam.socialismus.adapter.config.management.DefaultObjectMapperRegistry;
import me.whereareiam.socialismus.api.output.config.ConfigurationTypeResolver;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.jackson.annotation.JsonAutoDetect;
import me.whereareiam.socialismus.library.jackson.annotation.PropertyAccessor;
import me.whereareiam.socialismus.library.jackson.databind.DeserializationFeature;
import me.whereareiam.socialismus.library.jackson.databind.Module;
import me.whereareiam.socialismus.library.jackson.databind.ObjectMapper;
import me.whereareiam.socialismus.library.jackson.databind.json.JsonMapper;
import me.whereareiam.socialismus.library.jackson.dataformat.yaml.YAMLFactory;
import me.whereareiam.socialismus.library.jackson.dataformat.yaml.YAMLGenerator;
import me.whereareiam.socialismus.library.jackson.dataformat.yaml.YAMLMapper;

@Singleton
public class ObjectMapperProvider
implements Provider<ObjectMapper> {
    private final ConfigurationTypeResolver typeResolver;
    private final Set<Module> staticModules;
    private final DefaultObjectMapperRegistry registry;
    private ObjectMapper objectMapper;

    public synchronized ObjectMapper get() {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        switch (this.typeResolver.getConfigurationType()) {
            case JSON: {
                this.objectMapper = new JsonMapper();
                break;
            }
            case YAML: {
                YAMLFactory factory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.INDENT_ARRAYS).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR).disable(YAMLGenerator.Feature.SPLIT_LINES);
                this.objectMapper = new YAMLMapper(factory);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported configuration type");
            }
        }
        for (Module m : this.staticModules) {
            this.objectMapper.registerModule(m);
        }
        this.registry.applyAllTo(this.objectMapper);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        return this.objectMapper;
    }

    @Inject
    @Generated
    public ObjectMapperProvider(ConfigurationTypeResolver typeResolver, Set<Module> staticModules, DefaultObjectMapperRegistry registry) {
        this.typeResolver = typeResolver;
        this.staticModules = staticModules;
        this.registry = registry;
    }
}

