/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.api.type;

public enum PlatformType {
    BUKKIT,
    SPIGOT,
    PAPER,
    FOLIA,
    VELOCITY,
    UNKNOWN;


    public static PlatformType getType() {
        if (PlatformType.isVelocity()) {
            return VELOCITY;
        }
        if (PlatformType.isFolia()) {
            return FOLIA;
        }
        if (PlatformType.isPaper()) {
            return PAPER;
        }
        if (PlatformType.isSpigot()) {
            return SPIGOT;
        }
        if (PlatformType.isBukkit()) {
            return BUKKIT;
        }
        return UNKNOWN;
    }

    public static boolean isProxy() {
        return PlatformType.isVelocity();
    }

    public static boolean isGameServer() {
        return PlatformType.isBukkit() || PlatformType.isSpigot() || PlatformType.isPaper() || PlatformType.isFolia();
    }

    public static boolean isAtLeast(PlatformType platform) {
        return switch (platform.ordinal()) {
            case 0 -> {
                if (PlatformType.isBukkit() || PlatformType.isSpigot() || PlatformType.isPaper() || PlatformType.isFolia()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (PlatformType.isSpigot() || PlatformType.isPaper() || PlatformType.isFolia()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (PlatformType.isPaper() || PlatformType.isFolia()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> PlatformType.isFolia();
            default -> false;
        };
    }

    private static boolean isVelocity() {
        return PlatformType.isClassPresent("com.velocitypowered.api.plugin.Plugin");
    }

    private static boolean isFolia() {
        return PlatformType.isClassPresent("io.papermc.paper.threadedregions.ThreadedRegionizer");
    }

    private static boolean isPaper() {
        return PlatformType.isClassPresent("io.papermc.paper.threadedregions.scheduler.EntityScheduler");
    }

    private static boolean isSpigot() {
        return PlatformType.isClassPresent("org.spigotmc.SpigotConfig");
    }

    private static boolean isBukkit() {
        return PlatformType.isClassPresent("org.bukkit.Bukkit");
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return className.equals("org.bukkit.plugin.java.JavaPlugin");
        }
    }
}

