/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.api.type;

import java.util.Arrays;
import java.util.Comparator;

public enum Version {
    UNKNOWN,
    UNSUPPORTED,
    FUTURE,
    V_1_16,
    V_1_16_1,
    V_1_16_2,
    V_1_16_3,
    V_1_16_4,
    V_1_16_5,
    V_1_17,
    V_1_17_1,
    V_1_18,
    V_1_18_1,
    V_1_18_2,
    V_1_19,
    V_1_19_1,
    V_1_19_2,
    V_1_19_3,
    V_1_19_4,
    V_1_20,
    V_1_20_1,
    V_1_20_2,
    V_1_20_3,
    V_1_20_4,
    V_1_20_5,
    V_1_20_6,
    V_1_21,
    V_1_21_1,
    V_1_21_2,
    V_1_21_3,
    V_1_21_4,
    V_1_21_5,
    V_1_21_6,
    V_1_21_7,
    V_1_21_8;


    public static Version of(String version) {
        if (version == null || version.isEmpty()) {
            return UNSUPPORTED;
        }
        String normalizedVersion = version.split("[\\s-]")[0];
        try {
            return Version.valueOf("V_" + normalizedVersion.replace(".", "_"));
        }
        catch (IllegalArgumentException e) {
            Version latest = Version.getLatest();
            if (latest == UNSUPPORTED) {
                return UNSUPPORTED;
            }
            String[] latestVersionParts = latest.name().substring(2).split("_");
            String[] currentVersionParts = normalizedVersion.split("\\.");
            int minLength = Math.min(latestVersionParts.length, currentVersionParts.length);
            for (int i = 0; i < minLength; ++i) {
                try {
                    int latestPart = Integer.parseInt(latestVersionParts[i]);
                    int currentPart = Integer.parseInt(currentVersionParts[i]);
                    if (currentPart > latestPart) {
                        return FUTURE;
                    }
                    if (currentPart >= latestPart) continue;
                    return UNSUPPORTED;
                }
                catch (NumberFormatException ex) {
                    return UNSUPPORTED;
                }
            }
            if (currentVersionParts.length > latestVersionParts.length) {
                return FUTURE;
            }
            return UNSUPPORTED;
        }
    }

    public static Version getLatest() {
        return Arrays.stream(Version.values()).filter(version -> version != UNSUPPORTED && version != FUTURE).max(Comparator.comparing(v -> v.name().substring(2).replaceAll("_", "."))).orElse(UNSUPPORTED);
    }

    public static boolean isLowerThan(Version version1, Version version2) {
        return version1.ordinal() < version2.ordinal();
    }

    public static boolean isHigherThan(Version version1, Version version2) {
        return version1.ordinal() > version2.ordinal();
    }

    public boolean isAtLeast(Version version) {
        return !Version.isLowerThan(this, version);
    }
}

