/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.executor;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.command.CommandBase;
import me.whereareiam.socialismus.api.output.command.CommandCooldown;
import me.whereareiam.socialismus.command.builder.HelpBuilder;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.annotation.specifier.Range;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Default;
import org.incendo.cloud.annotations.Permission;

@Singleton
public class HelpCommand
extends CommandBase {
    private static final String COMMAND_NAME = "help";
    private final Provider<Map<String, CommandEntity>> commands;
    private final Provider<CommandManager<DummyPlayer>> commandManager;
    private final HelpBuilder helpBuilder;

    @Inject
    public HelpCommand(Provider<Map<String, CommandEntity>> commands, Provider<CommandManager<DummyPlayer>> commandManager, HelpBuilder helpBuilder) {
        super(COMMAND_NAME);
        this.commands = commands;
        this.commandManager = commandManager;
        this.helpBuilder = helpBuilder;
    }

    @Command(value="%command.help")
    @CommandDescription(value="%description.help")
    @CommandCooldown(value="%cooldown.help")
    @Permission(value={"%permission.help"})
    public void onCommand(DummyPlayer dummyPlayer, @Range(min="1") @Default(value="1") @Argument(value="page") int page) {
        Collection allowedCommands = ((CommandManager)this.commandManager.get()).commands().stream().filter(command -> dummyPlayer.getUsername() != null || ((CommandManager)this.commandManager.get()).hasPermission((Object)dummyPlayer, command.commandPermission().permissionString())).collect(Collectors.toList());
        dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, this.helpBuilder.buildHelpMessage(allowedCommands, page)));
    }

    @Override
    public CommandEntity getCommandEntity() {
        return (CommandEntity)((Map)this.commands.get()).get(COMMAND_NAME);
    }
}

