/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.listener;

import java.time.Duration;
import java.util.List;
import lombok.Generated;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.serializer.SerializerContent;
import me.whereareiam.socialismus.api.model.serializer.SerializerPlaceholder;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.processors.cooldown.CooldownInstance;
import org.incendo.cloud.processors.cooldown.listener.CooldownActiveListener;

@Singleton
public class CommandCooldownListener
implements CooldownActiveListener<DummyPlayer> {
    private final Provider<Messages> messages;

    public void cooldownActive(@NonNull DummyPlayer dummyPlayer, @NonNull Command<DummyPlayer> command, @NonNull CooldownInstance cooldown, @NonNull Duration remainingTime) {
        Logger.debug("Cooldown active for " + dummyPlayer.getUsername() + " on command " + command.rootComponent().name() + " for " + remainingTime.getSeconds() + " seconds", new Object[0]);
        dummyPlayer.sendMessage(Serializer.serialize(new SerializerContent(dummyPlayer, List.of(new SerializerPlaceholder("{time}", remainingTime.getSeconds() + "." + String.valueOf(remainingTime.getNano()).substring(0, 2))), ((Messages)this.messages.get()).getCommands().getCooldown())));
    }

    @Inject
    @Generated
    public CommandCooldownListener(Provider<Messages> messages) {
        this.messages = messages;
    }
}

