/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.provider;

import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.resource.CacheService;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import org.incendo.cloud.annotations.suggestion.Suggestions;

@Singleton
public final class CrossPlayerProvider {
    private static final String SET_KEY = "socialismus:players";
    private final Provider<CacheService> cache;
    private final Provider<Settings> settings;
    private final PlatformInteractor interactor;

    @Suggestions(value="crossPlayers")
    public Collection<String> suggestCrossPlayers() {
        Settings.Synchronization synchronization = ((Settings)this.settings.get()).getSynchronization();
        if (!synchronization.isEnabled() || !synchronization.isCrossPlayerSync()) {
            return this.interactor.getOnlinePlayers();
        }
        CacheService cache = (CacheService)this.cache.get();
        Set<String> players = cache.get(SET_KEY);
        return players.stream().sorted(String.CASE_INSENSITIVE_ORDER).toList();
    }

    @Inject
    @Generated
    public CrossPlayerProvider(Provider<CacheService> cache, Provider<Settings> settings, PlatformInteractor interactor) {
        this.cache = cache;
        this.settings = settings;
        this.interactor = interactor;
    }
}

