/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common;

import lombok.Generated;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.common.chat.worker.formatted.SynchronizationPublisher;
import me.whereareiam.socialismus.common.sync.ChatHistoryNetworkBridge;
import me.whereareiam.socialismus.common.sync.ChatNetworkBridge;
import me.whereareiam.socialismus.common.sync.CrossPlayerSyncBridge;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class SynchronizationService {
    private final Injector injector;
    private final Provider<Settings> settings;

    public void initialize() {
        Settings.Synchronization sync = ((Settings)this.settings.get()).getSynchronization();
        if (!sync.isEnabled()) {
            return;
        }
        ((ChatNetworkBridge)this.injector.getInstance(ChatNetworkBridge.class)).initialize();
        ((ChatHistoryNetworkBridge)this.injector.getInstance(ChatHistoryNetworkBridge.class)).initialize();
        if (sync.isCrossPlayerSync()) {
            ((CrossPlayerSyncBridge)this.injector.getInstance(CrossPlayerSyncBridge.class)).initialize();
        }
        this.injector.getInstance(SynchronizationPublisher.class);
    }

    public void applyTo(DummyPlayer player, String actualServerName) {
        Settings.Synchronization sync = ((Settings)this.settings.get()).getSynchronization();
        if (!sync.isEnabled()) {
            return;
        }
        if (sync.isUseRealServerName() && actualServerName != null) {
            player.setServer(actualServerName);
            return;
        }
        player.setServer(sync.getServer());
    }

    @Inject
    @Generated
    public SynchronizationService(Injector injector, Provider<Settings> settings) {
        this.injector = injector;
        this.settings = settings;
    }
}

