/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat;

import lombok.Generated;
import me.whereareiam.socialismus.api.input.chat.ChatCoordinationService;
import me.whereareiam.socialismus.api.input.container.ChatHistoryContainerService;
import me.whereareiam.socialismus.api.input.event.chat.ChatBroadcastEvent;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.chat.broadcast.ChatBroadcastPolicy;
import me.whereareiam.socialismus.common.chat.broadcast.ChatBroadcaster;
import me.whereareiam.socialismus.common.chat.processor.ChatMessageProcessor;
import me.whereareiam.socialismus.common.chat.processor.FormattedChatMessageProcessor;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatCoordinator
implements ChatCoordinationService {
    private final FormattedChatMessageProcessor formattedChatMessageProcessor;
    private final ChatHistoryContainerService chatHistoryContainer;
    private final ChatMessageProcessor chatMessageProcessor;
    private final ChatBroadcaster chatBroadcaster;
    private final ChatBroadcastPolicy policy;

    @Override
    public FormattedChatMessage coordinate(ChatMessage raw) {
        if ((raw = this.chatMessageProcessor.process(raw)).isCancelled()) {
            return ((FormattedChatMessage.FormattedChatMessageBuilder)FormattedChatMessage.builder().cancelled(true)).build();
        }
        FormattedChatMessage formatted = this.formattedChatMessageProcessor.process(raw);
        this.broadcastAndStore(formatted);
        return formatted;
    }

    public void coordinate(FormattedChatMessage formatted) {
        if (formatted.isCancelled()) {
            return;
        }
        FormattedChatMessage processed = (FormattedChatMessage)this.chatMessageProcessor.process(formatted);
        processed.setFormat(formatted.getFormat());
        if (processed.isCancelled()) {
            return;
        }
        this.broadcastAndStore(processed);
    }

    private void broadcastAndStore(FormattedChatMessage msg) {
        EventUtil.callEvent(new ChatBroadcastEvent(msg, msg.isCancelled()), () -> {
            msg.getSender().setLastChat(msg.getChat());
            if (this.policy.allows(msg)) {
                this.chatBroadcaster.broadcast(msg);
            }
            this.chatHistoryContainer.addMessage(msg.getId(), msg);
        });
    }

    @Inject
    @Generated
    public ChatCoordinator(FormattedChatMessageProcessor formattedChatMessageProcessor, ChatHistoryContainerService chatHistoryContainer, ChatMessageProcessor chatMessageProcessor, ChatBroadcaster chatBroadcaster, ChatBroadcastPolicy policy) {
        this.formattedChatMessageProcessor = formattedChatMessageProcessor;
        this.chatHistoryContainer = chatHistoryContainer;
        this.chatMessageProcessor = chatMessageProcessor;
        this.chatBroadcaster = chatBroadcaster;
        this.policy = policy;
    }
}

