/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.event.EventListener;
import me.whereareiam.socialismus.api.input.event.EventManager;
import me.whereareiam.socialismus.api.input.event.base.CancellableEvent;
import me.whereareiam.socialismus.api.input.event.base.Event;
import me.whereareiam.socialismus.api.input.event.base.EventOrder;
import me.whereareiam.socialismus.api.input.event.base.SocialisticEvent;
import me.whereareiam.socialismus.common.event.RegisteredListener;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class EventController
implements EventManager {
    private final Map<Class<?>, List<RegisteredListener>> listeners = new HashMap();
    private final ExecutorService executor = Executors.newCachedThreadPool();

    @Override
    public void register(EventListener listener) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SocialisticEvent.class)) continue;
            Class<?> eventType = method.getParameterTypes()[0];
            EventOrder order = method.getAnnotation(SocialisticEvent.class).value();
            this.listeners.computeIfAbsent(eventType, k -> new ArrayList()).add(new RegisteredListener(listener, method, order));
            this.listeners.get(eventType).sort(Comparator.comparing(RegisteredListener::getOrder));
        }
    }

    @Override
    public <T extends Event> void registerListener(Class<T> event, Object listener, Method method, EventOrder order) {
        this.listeners.computeIfAbsent(event, k -> new ArrayList()).add(new RegisteredListener((EventListener)listener, method, order));
        this.listeners.get(event).sort(Comparator.comparing(RegisteredListener::getOrder));
    }

    @Override
    public void unregister(EventListener eventListener) {
        this.listeners.values().forEach(list -> list.removeIf(listener -> listener.getListener().equals(eventListener)));
    }

    private void collectEventTypes(Class<?> clazz, Set<Class<?>> types) {
        if (clazz == null || !Event.class.isAssignableFrom(clazz)) {
            return;
        }
        types.add(clazz);
        this.collectEventTypes(clazz.getSuperclass(), types);
        for (Class<?> iface : clazz.getInterfaces()) {
            this.collectEventTypes(iface, types);
        }
    }

    @Override
    public void call(Event event) {
        HashSet eventTypes = new HashSet();
        this.collectEventTypes(event.getClass(), eventTypes);
        List<RegisteredListener> eventListeners = eventTypes.stream().flatMap(type -> this.listeners.getOrDefault(type, Collections.emptyList()).stream()).sorted(Comparator.comparing(RegisteredListener::getOrder)).toList();
        if (eventListeners.isEmpty()) {
            return;
        }
        for (RegisteredListener listener : eventListeners) {
            this.executor.submit(() -> {
                try {
                    listener.getMethod().invoke((Object)listener.getListener(), event);
                }
                catch (Exception e) {
                    Logger.severe("Failed to call event " + event.getClass().getSimpleName() + " for listener " + listener.getListener().getClass().getSimpleName(), new Object[0]);
                    e.printStackTrace();
                }
            });
            if (!(event instanceof CancellableEvent) || !((CancellableEvent)((Object)event)).isCancelled()) continue;
            Logger.debug("Event " + event.getClass().getSimpleName() + " was cancelled", new Object[0]);
            break;
        }
    }
}

