/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.requirement.validation;

import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.registry.ExtendedRegistry;
import me.whereareiam.socialismus.api.input.requirement.RequirementValidation;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.model.requirement.type.ServerRequirement;
import me.whereareiam.socialismus.api.type.requirement.RequirementType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ServerRequirementValidation
implements RequirementValidation {
    @Inject
    public ServerRequirementValidation(ExtendedRegistry<RequirementType, RequirementValidation> registry) {
        registry.register(RequirementType.SERVER, this);
    }

    @Override
    public boolean check(Requirement requirement, DummyPlayer dummyPlayer) {
        String[] expectedValues;
        if (!(requirement instanceof ServerRequirement)) {
            return false;
        }
        ServerRequirement sr = (ServerRequirement)requirement;
        String server = dummyPlayer.getServer();
        if (server == null) {
            return false;
        }
        Logger.debug("Checking server requirement for player {}", dummyPlayer.getUsername());
        boolean checkResult = false;
        switch (sr.getCondition()) {
            case EQUALS: {
                checkResult = sr.getServers().size() == 1 && sr.getServers().get(0).equals(server);
                break;
            }
            case CONTAINS: {
                checkResult = sr.getServers().contains(server);
            }
        }
        for (String expectedValue : expectedValues = sr.getExpected().split("\\|")) {
            if (!String.valueOf(checkResult).equals(expectedValue)) continue;
            Logger.debug("Server check result {} for player {}", checkResult, dummyPlayer.getUsername());
            return true;
        }
        return false;
    }
}

