/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.requirement.validation;

import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.registry.ExtendedRegistry;
import me.whereareiam.socialismus.api.input.requirement.RequirementValidation;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.model.requirement.type.WorldRequirement;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.requirement.RequirementType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class WorldRequirementValidation
implements RequirementValidation {
    @Inject
    public WorldRequirementValidation(ExtendedRegistry<RequirementType, RequirementValidation> registry) {
        registry.register(RequirementType.WORLD, this);
    }

    @Override
    public boolean check(Requirement requirement, DummyPlayer dummyPlayer) {
        String[] expectedValues;
        if (!(requirement instanceof WorldRequirement)) {
            return false;
        }
        WorldRequirement wr = (WorldRequirement)requirement;
        if (!PlatformType.isGameServer()) {
            return false;
        }
        Logger.debug("Checking world requirement for player " + dummyPlayer.getUsername(), new Object[0]);
        boolean checkResult = false;
        switch (wr.getCondition()) {
            case EQUALS: {
                checkResult = wr.getWorlds().size() == 1 && wr.getWorlds().get(0).equals(dummyPlayer.getLocation());
                break;
            }
            case CONTAINS: {
                checkResult = wr.getWorlds().contains(dummyPlayer.getLocation());
            }
        }
        for (String expectedValue : expectedValues = wr.getExpected().split("\\|")) {
            if (!String.valueOf(checkResult).equals(expectedValue)) continue;
            Logger.debug("World check result " + checkResult + " for player " + dummyPlayer.getUsername(), new Object[0]);
            return true;
        }
        Logger.debug("World check result " + checkResult + " for player " + dummyPlayer.getUsername(), new Object[0]);
        return false;
    }
}

