/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.updater;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import me.whereareiam.socialismus.api.AnsiColor;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.updater.UpdateProvider;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.module.UpdateSpecification;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.api.output.module.ModuleService;
import me.whereareiam.socialismus.api.type.module.ProviderType;
import me.whereareiam.socialismus.common.updater.UpdateProviderRegistry;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public final class UpdateScheduler {
    private static final long MS_PER_HOUR = 3600000L;
    private static final int BRANCH_UPDATE_LIMIT = 50;
    private static final UpdateSpecification CORE_SPEC = ((UpdateSpecification.UpdateSpecificationBuilder)((UpdateSpecification.UpdateSpecificationBuilder)UpdateSpecification.builder().release((UpdateSpecification.Spec)((UpdateSpecification.Spec.SpecBuilder)((UpdateSpecification.Spec.SpecBuilder)UpdateSpecification.Spec.builder().provider(ProviderType.MODRINTH)).id("socialismus")).build())).dev((UpdateSpecification.Spec)((UpdateSpecification.Spec.SpecBuilder)((UpdateSpecification.Spec.SpecBuilder)UpdateSpecification.Spec.builder().provider(ProviderType.GITHUB)).id("whereareiam/Socialismus")).build())).build();
    private final Provider<Settings> settings;
    private final Scheduler scheduler;
    private final ModuleService moduleService;
    private final UpdateProviderRegistry providers;

    public void start() {
        Settings.Updater cfg = ((Settings)this.settings.get()).getUpdater();
        if (!cfg.isCheckForUpdates() || cfg.getInterval() <= 0) {
            return;
        }
        this.scheduler.schedule((PeriodicalRunnableTask)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((PeriodicalRunnableTask.PeriodicalRunnableTaskBuilder)((RunnableTask.RunnableTaskBuilder)PeriodicalRunnableTask.builder().period((long)cfg.getInterval() * 3600000L)).runnable(this::runOnce)).module("main")).delay(0L)).build(), true);
    }

    /*
     * Exception decompiling
     */
    private void runOnce() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkEntry(String name, String current, UpdateSpecification spec, Settings.Updater cfg) {
        if (spec.getRelease() == null && spec.getDev() == null) {
            return;
        }
        if ("DEV".equalsIgnoreCase(current)) {
            if (cfg.isWarnAboutLocalBuilds()) {
                Logger.info(String.valueOf((Object)AnsiColor.RED) + "You are running a local dev build of " + name + "." + String.valueOf((Object)AnsiColor.RESET), new Object[0]);
            }
            return;
        }
        if (!UpdateScheduler.isReleaseVersion(current)) {
            if (cfg.isWarnAboutDevBuilds() && spec.getDev() != null) {
                UpdateSpecification.Spec devSpec = spec.getDev();
                UpdateProvider prov = this.providers.by(devSpec);
                this.warnAheadBehindBranches(current, name, prov, devSpec);
            }
            return;
        }
        if (cfg.isWarnAboutUpdates() && spec.getRelease() != null) {
            UpdateSpecification.Spec relSpec = spec.getRelease();
            UpdateProvider prov = this.providers.by(relSpec);
            try {
                prov.fetchLatest(relSpec).ifPresent(latest -> {
                    if (!UpdateScheduler.bothPureSemver(current, latest)) {
                        Logger.debug("Skipping semver compare for %s: current=\"%s\", latest=\"%s\"", name, current, latest);
                        return;
                    }
                    if (UpdateScheduler.compareSemver(latest, current) > 0) {
                        Logger.warn("The version of " + name + " you are using is outdated. Current version: " + current + ", latest version: " + latest, new Object[0]);
                        return;
                    }
                    Logger.info("You are using the latest version of " + name + ".", new Object[0]);
                });
            }
            catch (IOException ex) {
                Logger.debug("Failed to check for new releases for " + name + ". " + ex.getMessage(), new Object[0]);
            }
        }
    }

    private void warnAheadBehindBranches(String version, String name, UpdateProvider provider, UpdateSpecification.Spec spec) {
        String prefix = version.substring(version.lastIndexOf(45) + 1).toLowerCase(Locale.ROOT);
        try {
            List<String> updates = provider.fetchRecentUpdates(spec, 50);
            int behind = 0;
            for (String id : updates) {
                if (id.toLowerCase(Locale.ROOT).startsWith(prefix)) break;
                ++behind;
            }
            if (behind == 0) {
                Logger.info("You are using the latest dev build of " + name + ".", new Object[0]);
                return;
            }
            Logger.warn("You are " + behind + " commit" + (behind == 1 ? "" : "s") + " behind the latest dev build of " + name + ".", new Object[0]);
        }
        catch (IOException ex) {
            Logger.debug("Failed to check for new dev builds for " + name + ". " + ex.getMessage(), new Object[0]);
        }
    }

    private static boolean isReleaseVersion(String v) {
        return v.matches("\\d+\\.\\d+\\.\\d+(?:-[0-9A-Za-z.-]+)?");
    }

    private static boolean bothPureSemver(String a, String b) {
        return a.matches("\\d+\\.\\d+\\.\\d+") && b.matches("\\d+\\.\\d+\\.\\d+");
    }

    private static int compareSemver(String a, String b) {
        String[] xa = a.split("\\.");
        String[] xb = b.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int diff = Integer.parseInt(xa[i]) - Integer.parseInt(xb[i]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Inject
    @Generated
    public UpdateScheduler(Provider<Settings> settings, Scheduler scheduler, ModuleService moduleService, UpdateProviderRegistry providers) {
        this.settings = settings;
        this.scheduler = scheduler;
        this.moduleService = moduleService;
        this.providers = providers;
    }

    private /* synthetic */ void lambda$runOnce$2(Settings.Updater cfg, Object[] t) {
        this.checkEntry((String)t[0], (String)t[1], (UpdateSpecification)t[2], cfg);
    }

    private static /* synthetic */ boolean lambda$runOnce$1(Object[] t) {
        return t[2] != null;
    }
}

