/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.position.Position;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public abstract class AbstractPlatformInteractor
implements PlatformInteractor {
    @Override
    public Position getPosition(DummyPlayer dummyPlayer) {
        Player player = Bukkit.getPlayer((UUID)dummyPlayer.getUniqueId());
        if (player == null) {
            return null;
        }
        Location location = player.getLocation();
        return new Position(location.getX(), location.getY(), location.getZ());
    }

    @Override
    public Position getEyePosition(DummyPlayer dummyPlayer) {
        Player player = Bukkit.getPlayer((UUID)dummyPlayer.getUniqueId());
        if (player == null) {
            return null;
        }
        Location location = player.getEyeLocation();
        return new Position(location.getX(), location.getY(), location.getZ());
    }

    @Override
    public boolean areWithinRange(UUID player1, UUID player2, double range) {
        Player p1 = Bukkit.getPlayer((UUID)player1);
        Player p2 = Bukkit.getPlayer((UUID)player2);
        if (p1 == null || p2 == null) {
            return false;
        }
        if (!p1.getWorld().equals((Object)p2.getWorld())) {
            return false;
        }
        return p1.getLocation().distanceSquared(p2.getLocation()) <= range * range;
    }

    @Override
    public boolean hasPermission(String username, String permission) {
        Player player = Bukkit.getPlayer((String)username);
        if (player == null) {
            return false;
        }
        return player.hasPermission(permission);
    }

    @Override
    public boolean hasPermission(DummyPlayer dummyPlayer, String permission) {
        Player player = Bukkit.getPlayer((UUID)dummyPlayer.getUniqueId());
        if (player == null) {
            return false;
        }
        return player.hasPermission(permission);
    }

    @Override
    public List<String> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
    }

    @Override
    public int getOnlinePlayersCount() {
        return Bukkit.getOnlinePlayers().size();
    }

    @Override
    public Version getServerVersion() {
        return Version.of(Bukkit.getVersion());
    }

    @Inject
    @Generated
    public AbstractPlatformInteractor() {
    }
}

