/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.listener.connection;

import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.bukkit.event.player.PlayerQuitEvent;

@Singleton
public class PlayerQuitListener
implements DynamicListener<PlayerQuitEvent> {
    private final Provider<Settings> settings;
    private final PlayerContainerService containerService;

    @Inject
    public PlayerQuitListener(Provider<Settings> settings, PlayerContainerService containerService) {
        this.settings = settings;
        this.containerService = containerService;
    }

    @Override
    public void onEvent(PlayerQuitEvent event) {
        if (((Settings)this.settings.get()).getMisc().isDisableQuitNotification()) {
            event.setQuitMessage(null);
        }
        this.containerService.removePlayer(event.getPlayer().getUniqueId());
    }
}

