/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.paper;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@Singleton
public class PaperScheduler
implements Scheduler {
    private final Plugin plugin;
    private final Map<String, Map<Integer, ScheduledTask>> tasks = new ConcurrentHashMap<String, Map<Integer, ScheduledTask>>();
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(1);

    @Inject
    public PaperScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.checkAsyncSchedulerAvailability();
    }

    private void checkAsyncSchedulerAvailability() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AsyncScheduler not found. Please use Paper version 1.20 or newer.", e);
        }
    }

    private int ensureId(RunnableTask task) {
        int existing = task.getId();
        if (existing <= 0) {
            int generated = ID_GENERATOR.getAndIncrement();
            task.setId(generated);
            return generated;
        }
        return existing;
    }

    @Override
    public void schedule(RunnableTask runnableTask) {
        int id = this.ensureId(runnableTask);
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.plugin, t -> runnableTask.getRunnable().run());
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask) {
        int id = this.ensureId(runnableTask);
        ScheduledTask task = Bukkit.getAsyncScheduler().runDelayed(this.plugin, t -> runnableTask.getRunnable().run(), runnableTask.getDelay(), TimeUnit.MILLISECONDS);
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask) {
        int id = this.ensureId(runnableTask);
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(this.plugin, t -> runnableTask.getRunnable().run(), runnableTask.getDelay(), runnableTask.getPeriod(), TimeUnit.MILLISECONDS);
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(RunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void cancel(RunnableTask runnableTask) {
        Map<Integer, ScheduledTask> moduleTasks = this.tasks.get(runnableTask.getModule());
        if (moduleTasks != null) {
            Integer id = runnableTask.getId();
            ScheduledTask task = moduleTasks.remove(id);
            if (task != null) {
                task.cancel();
            }
            if (moduleTasks.isEmpty()) {
                this.tasks.remove(runnableTask.getModule());
            }
        }
    }

    @Override
    public void cancel(DelayedRunnableTask runnableTask) {
        this.cancel((RunnableTask)runnableTask);
    }

    @Override
    public void cancelByModule(String module) {
        Map<Integer, ScheduledTask> moduleTasks = this.tasks.remove(module);
        if (moduleTasks != null) {
            moduleTasks.values().forEach(ScheduledTask::cancel);
        }
    }
}

