/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.paper.listener.chat;

import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import me.whereareiam.socialismus.api.input.sync.ChatSyncBus;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.common.chat.ChatCoordinator;
import me.whereareiam.socialismus.common.chat.ChatMessageFactory;
import me.whereareiam.socialismus.common.chat.broadcast.ChatBroadcaster;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.paper.renderer.SocialismusRenderer;
import org.bukkit.entity.Player;

@Singleton
public class PlayerChatListener
implements DynamicListener<AsyncChatEvent> {
    private final ChatSyncBus chatSyncBus;
    private final ChatCoordinator chatCoordinator;
    private final ChatMessageFactory chatMessageFactory;
    private final ChatBroadcaster chatBroadcaster;

    @Override
    public void onEvent(AsyncChatEvent event) {
        Player sender = event.getPlayer();
        Set nonPlayerAudiences = event.viewers().stream().filter(aud -> !(aud instanceof Player)).collect(Collectors.toSet());
        Set<UUID> playerRecipientUuids = event.viewers().stream().filter(aud -> aud instanceof Player).map(aud -> ((Player)aud).getUniqueId()).collect(Collectors.toSet());
        ChatMessage chatMessage = this.chatMessageFactory.createChatMessage(sender.getUniqueId(), playerRecipientUuids, event.message());
        FormattedChatMessage formatted = this.chatCoordinator.coordinate(chatMessage);
        if (formatted == null || formatted.isCancelled() || !formatted.isVanillaSending()) {
            event.setCancelled(true);
            return;
        }
        event.viewers().clear();
        Set newPlayerViewers = formatted.getRecipients().stream().map(rec -> sender.getServer().getPlayer(rec.getUniqueId())).filter(Objects::nonNull).collect(Collectors.toSet());
        event.viewers().addAll(newPlayerViewers);
        event.viewers().addAll(nonPlayerAudiences);
        event.renderer((ChatRenderer)new SocialismusRenderer(formatted, this.chatBroadcaster));
    }

    @Inject
    @Generated
    public PlayerChatListener(ChatSyncBus chatSyncBus, ChatCoordinator chatCoordinator, ChatMessageFactory chatMessageFactory, ChatBroadcaster chatBroadcaster) {
        this.chatSyncBus = chatSyncBus;
        this.chatCoordinator = chatCoordinator;
        this.chatMessageFactory = chatMessageFactory;
        this.chatBroadcaster = chatBroadcaster;
    }
}

