/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.paper.mapper;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.model.player.DummyCommandPlayer;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.ConsoleCommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.SenderMapper;

@Singleton
public class CommandSourceStackMapper
implements SenderMapper<CommandSourceStack, DummyPlayer> {
    private final PlayerContainerService playerContainer;

    @Inject
    public CommandSourceStackMapper(PlayerContainerService playerContainer) {
        this.playerContainer = playerContainer;
    }

    public @NonNull DummyPlayer map(@NonNull CommandSourceStack source) {
        if (source.getSender() instanceof ConsoleCommandSender || source.getSender().getClass().getName().equals("io.papermc.paper.brigadier.NullCommandSender")) {
            return ((DummyCommandPlayer.DummyCommandPlayerBuilder)((DummyPlayer.DummyPlayerBuilder)DummyCommandPlayer.builder().commandSender(source)).audience((Audience)source.getSender())).build();
        }
        Optional<DummyPlayer> dummyPlayer = this.playerContainer.getPlayer(source.getSender().getName());
        if (dummyPlayer.isPresent()) {
            return DummyCommandPlayer.from(dummyPlayer.get(), source);
        }
        throw new NullPointerException("A player with the name " + source.getSender().getName() + " was not found");
    }

    @Nonnull
    public CommandSourceStack reverse(@Nonnull DummyPlayer dummyPlayer) {
        return (CommandSourceStack)((DummyCommandPlayer)dummyPlayer).getCommandSender();
    }
}

