/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.management;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import me.whereareiam.socialismus.adapter.config.deserializer.RequirementDeserializer;
import me.whereareiam.socialismus.adapter.config.deserializer.VersionDeserializer;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.output.DefaultConfig;
import me.whereareiam.socialismus.api.output.config.ConfigurationManager;
import me.whereareiam.socialismus.api.type.ConfigurationType;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;
import me.whereareiam.socialismus.library.jackson.databind.DeserializationFeature;
import me.whereareiam.socialismus.library.jackson.databind.JsonDeserializer;
import me.whereareiam.socialismus.library.jackson.databind.JsonSerializer;
import me.whereareiam.socialismus.library.jackson.databind.Module;
import me.whereareiam.socialismus.library.jackson.databind.ObjectMapper;
import me.whereareiam.socialismus.library.jackson.databind.json.JsonMapper;
import me.whereareiam.socialismus.library.jackson.databind.module.SimpleModule;
import me.whereareiam.socialismus.library.jackson.dataformat.yaml.YAMLFactory;
import me.whereareiam.socialismus.library.jackson.dataformat.yaml.YAMLGenerator;
import me.whereareiam.socialismus.library.jackson.dataformat.yaml.YAMLMapper;

@Singleton
public class ConfigManager
implements Provider<ObjectMapper>,
ConfigurationManager {
    private final Injector injector;
    private final Path dataPath;
    private final Map<Class<?>, DefaultConfig<?>> templates = new HashMap();
    private ObjectMapper objectMapper;

    @Inject
    public ConfigManager(Injector injector, @Named(value="dataPath") Path dataPath, Map<Class<?>, DefaultConfig<?>> templates) {
        this.injector = injector;
        this.dataPath = dataPath;
        this.templates.putAll(templates);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigurationType getConfigurationType() {
        try (Stream<Path> paths = Files.list(this.dataPath);){
            Optional<Path> configFile = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().startsWith("type")).findFirst();
            if (configFile.isPresent()) {
                String[] parts = configFile.get().getFileName().toString().split("=");
                ConfigurationType configurationType2 = ConfigurationType.valueOf(parts[1].toUpperCase());
                return configurationType2;
            }
            Files.createFile(this.dataPath.resolve("type=YAML"), new FileAttribute[0]);
            ConfigurationType configurationType = ConfigurationType.YAML;
            return configurationType;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get configuration type", e);
        }
    }

    @Override
    public void addDeserializer(Class<?> clazz, Object deserializer) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(clazz, (JsonDeserializer)deserializer);
        this.objectMapper.registerModule((Module)module);
    }

    @Override
    public void addSerializer(Class<?> clazz, Object serializer) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(clazz, (JsonSerializer)serializer);
        this.objectMapper.registerModule((Module)module);
    }

    @Override
    public void addTemplate(Class<?> clazz, DefaultConfig<?> template) {
        this.templates.put(clazz, template);
    }

    @Override
    public <T> DefaultConfig<T> getTemplate(Class<T> clazz) {
        return this.templates.get(clazz);
    }

    public ObjectMapper get() {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        switch (this.getConfigurationType()) {
            case JSON: {
                this.objectMapper = new JsonMapper();
                break;
            }
            case YAML: {
                YAMLFactory yamlFactory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.INDENT_ARRAYS).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR).disable(YAMLGenerator.Feature.SPLIT_LINES);
                this.objectMapper = new YAMLMapper(yamlFactory);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported configuration type");
            }
        }
        this.addDeserializer(Requirement.class, this.injector.getInstance(RequirementDeserializer.class));
        this.addDeserializer(Version.class, this.injector.getInstance(VersionDeserializer.class));
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return this.objectMapper;
    }
}

