/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider;

import java.nio.file.Path;
import me.whereareiam.socialismus.adapter.config.management.ConfigLoader;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class SettingsProvider
implements Provider<Settings>,
Reloadable {
    private final Path dataPath;
    private final ConfigLoader configLoader;
    private Settings settings;

    @Inject
    public SettingsProvider(@Named(value="dataPath") Path dataPath, ConfigLoader configLoader, Registry<Reloadable> registry) {
        this.dataPath = dataPath;
        this.configLoader = configLoader;
        registry.register(this);
    }

    public Settings get() {
        if (this.settings != null) {
            return this.settings;
        }
        this.load();
        return this.settings;
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.settings = this.configLoader.load(this.dataPath.resolve("settings"), Settings.class);
    }
}

