/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider.chat;

import java.nio.file.Path;
import me.whereareiam.socialismus.adapter.config.management.ConfigLoader;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class ChatMessagesProvider
implements Provider<ChatMessages>,
Reloadable {
    private final Path dataPath;
    private final ConfigLoader configLoader;
    private ChatMessages chatMessages;

    @Inject
    public ChatMessagesProvider(@Named(value="chatPath") Path dataPath, ConfigLoader configLoader, Registry<Reloadable> registry) {
        this.dataPath = dataPath;
        this.configLoader = configLoader;
        registry.register(this);
    }

    public ChatMessages get() {
        if (this.chatMessages != null) {
            return this.chatMessages;
        }
        this.load();
        return this.chatMessages;
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.chatMessages = this.configLoader.load(this.dataPath.resolve("messages"), ChatMessages.class);
    }
}

