/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider.chat;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.whereareiam.socialismus.adapter.config.dynamic.ChatsConfig;
import me.whereareiam.socialismus.adapter.config.management.ConfigLoader;
import me.whereareiam.socialismus.adapter.config.management.ConfigManager;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.chat.Chat;
import me.whereareiam.socialismus.api.type.ConfigurationType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class ChatsProvider
implements Provider<List<Chat>>,
Reloadable {
    private final Path dataPath;
    private final ConfigLoader configLoader;
    private final ConfigurationType configurationType;
    private List<Chat> chats;

    @Inject
    public ChatsProvider(@Named(value="chatPath") Path dataPath, ConfigLoader configLoader, ConfigManager configManager, Registry<Reloadable> registry) {
        this.dataPath = dataPath;
        this.configLoader = configLoader;
        this.configurationType = configManager.getConfigurationType();
        registry.register(this);
    }

    public List<Chat> get() {
        if (this.chats != null) {
            return this.chats;
        }
        this.loadChats();
        return this.chats;
    }

    @Override
    public void reload() {
        this.loadChats();
    }

    private void loadChats() {
        this.chats = new ArrayList<Chat>();
        try (Stream<Path> paths = Files.list(this.dataPath);){
            paths.filter(path -> path.getFileName().toString().endsWith(this.configurationType.getExtension())).forEach(path -> {
                String fileName = path.getFileName().toString().replace(this.configurationType.getExtension(), "");
                if (Files.isDirectory(path, new LinkOption[0]) || fileName.startsWith("messages") || fileName.startsWith("settings") || fileName.isEmpty()) {
                    return;
                }
                this.chats.addAll(this.addChatsFromConfig(path.getParent().resolve(fileName)));
            });
        }
        catch (IOException e) {
            Logger.severe("Failed to load chat configurations", e);
            this.chats = Collections.emptyList();
            return;
        }
        if (this.chats.isEmpty()) {
            this.chats.addAll(this.addChatsFromConfig(this.dataPath.resolve("chats-default")));
        }
        this.chats.removeIf(chat -> this.chats.stream().anyMatch(c -> c != chat && c.getId().equals(chat.getId())));
    }

    private List<Chat> addChatsFromConfig(Path path) {
        ChatsConfig chatsConfig = this.configLoader.load(path, ChatsConfig.class);
        return chatsConfig.getChats().stream().filter(Chat::isEnabled).toList();
    }
}

