/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.module;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleDependencyResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModulePlatformResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleResolver;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleVersionResolver;
import me.whereareiam.socialismus.api.AnsiColor;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.model.module.InternalModule;
import me.whereareiam.socialismus.api.output.PlatformClassLoader;
import me.whereareiam.socialismus.api.output.module.SocialisticModule;
import me.whereareiam.socialismus.api.type.module.ModuleState;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ModuleLifecycleController {
    private final Injector injector;
    private final PlatformClassLoader platformClassLoader;
    private final List<ModuleResolver> resolvers;

    @Inject
    public ModuleLifecycleController(Injector injector, PlatformClassLoader platformClassLoader) {
        this.injector = injector;
        this.platformClassLoader = platformClassLoader;
        this.resolvers = List.of((ModuleResolver)injector.getInstance(ModuleDependencyResolver.class), (ModuleResolver)injector.getInstance(ModuleVersionResolver.class), (ModuleResolver)injector.getInstance(ModulePlatformResolver.class));
    }

    public void loadModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.UNKNOWN)) {
            return;
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{module.getPath().toUri().toURL()}, this.platformClassLoader.getClassLoader());
            Class<?> moduleClass = Class.forName(module.getMain(), true, loader);
            module.setModule((SocialisticModule)this.injector.getInstance(moduleClass));
            module.setState(ModuleState.LOADED);
            module.getModule().setModule(module);
            module.getModule().setWorkingPath(module.getPath().getParent().resolve(module.getName()));
            this.injector.injectMembers((Object)module.getModule());
            if (this.checkRequirements(module)) {
                return;
            }
            Logger.info("Loaded module " + String.valueOf((Object)AnsiColor.YELLOW) + module.getName() + String.valueOf((Object)AnsiColor.RESET) + " v" + module.getVersion() + " [" + String.join((CharSequence)", ", module.getAuthors()) + "]", new Object[0]);
            module.getModule().onLoad();
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            Logger.severe("Failed to load module " + module.getName() + ": " + String.valueOf(e), new Object[0]);
            module.setState(ModuleState.ERROR);
        }
    }

    public void enableModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.LOADED)) {
            return;
        }
        module.setState(ModuleState.ENABLED);
        module.getModule().onEnable();
    }

    public void disableModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.ENABLED)) {
            return;
        }
        module.setState(ModuleState.DISABLED);
        module.getModule().onDisable();
    }

    public void unloadModule(InternalModule module) {
        if (!module.getState().equals((Object)ModuleState.DISABLED)) {
            return;
        }
        module.setState(ModuleState.UNLOADED);
        module.getModule().onUnload();
    }

    private boolean checkRequirements(InternalModule module) {
        for (ModuleResolver resolver : this.resolvers) {
            if (resolver.resolve(module)) continue;
            module.setState(ModuleState.ERROR);
            return true;
        }
        return false;
    }
}

