/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.builder;

import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class PaginationBuilder {
    private final Provider<Settings> settings;
    private final Provider<Messages> messages;

    @Inject
    public PaginationBuilder(Provider<Settings> settings, Provider<Messages> messages) {
        this.settings = settings;
        this.messages = messages;
    }

    public String build(String message, int totalCommands, int currentPage) {
        int commandsPerPage = ((Settings)this.settings.get()).getMisc().getCommandsPerPage();
        int totalPages = (int)Math.ceil((double)totalCommands / (double)commandsPerPage);
        if (totalPages <= 1 && !((Messages)this.messages.get()).getCommands().getPagination().isShowPaginationIfOnePage()) {
            return message.replace("{pagination}", "");
        }
        String pagination = this.formatPagination(currentPage, totalPages);
        return message.replace("{pagination}", pagination);
    }

    private String formatPagination(int currentPage, int totalPages) {
        String previousLink = this.buildPreviousLink(currentPage);
        String nextLink = this.buildNextLink(currentPage, totalPages);
        String paginationFormat = ((Messages)this.messages.get()).getCommands().getPagination().getFormat();
        return paginationFormat.replace("{previous}", previousLink).replace("{next}", nextLink).replace("{current}", Integer.toString(currentPage)).replace("{max}", Integer.toString(totalPages));
    }

    private String buildPreviousLink(int currentPage) {
        if (currentPage > 1) {
            return ((Messages)this.messages.get()).getCommands().getPagination().getPreviousTagFormat().replace("{previousPage}", Integer.toString(currentPage - 1));
        }
        return ((Messages)this.messages.get()).getCommands().getPagination().isShowPreviousEvenIfFirst() ? ((Messages)this.messages.get()).getCommands().getPagination().getPreviousTagFormat().replace("{previousPage}", "1") : "";
    }

    private String buildNextLink(int currentPage, int totalPages) {
        if (currentPage < totalPages) {
            return ((Messages)this.messages.get()).getCommands().getPagination().getNextTagFormat().replace("{nextPage}", Integer.toString(currentPage + 1));
        }
        return ((Messages)this.messages.get()).getCommands().getPagination().isShowNextEvenIfLast() ? ((Messages)this.messages.get()).getCommands().getPagination().getNextTagFormat().replace("{nextPage}", Integer.toString(totalPages)) : "";
    }
}

