/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.executor;

import java.util.Map;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.command.CommandBase;
import me.whereareiam.socialismus.api.output.command.CommandCooldown;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.PluginType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Permission;

@Singleton
public class DebugCommand
extends CommandBase {
    private static final String COMMAND_NAME = "debug";
    private final Provider<Map<String, CommandEntity>> commands;
    private final Provider<Messages> messages;
    private final PlatformInteractor platformInteractor;

    @Inject
    public DebugCommand(Provider<Map<String, CommandEntity>> commands, Provider<Messages> messages, PlatformInteractor platformInteractor) {
        super(COMMAND_NAME);
        this.commands = commands;
        this.messages = messages;
        this.platformInteractor = platformInteractor;
    }

    @Command(value="%command.debug")
    @CommandDescription(value="%description.debug")
    @CommandCooldown(value="%cooldown.debug")
    @Permission(value={"%permission.debug"})
    public void onCommand(DummyPlayer dummyPlayer) {
        String message = String.join((CharSequence)"\n", ((Messages)this.messages.get()).getCommands().getDebugCommand().getFormat());
        message = message.replace("{serverVersion}", this.platformInteractor.getServerVersion().name()).replace("{pluginVersion}", "DEV").replace("{serverPlatform}", PlatformType.getType().name()).replace("{pluginPlatform}", PluginType.getType().name()).replace("{javaVersion}", System.getProperty("java.version")).replace("{os}", System.getProperty("os.name"));
        dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, message));
    }

    @Override
    public CommandEntity getCommandEntity() {
        return (CommandEntity)((Map)this.commands.get()).get(COMMAND_NAME);
    }
}

