/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat;

import java.util.List;
import me.whereareiam.socialismus.api.input.chat.ChatHistoryService;
import me.whereareiam.socialismus.api.input.container.ChatHistoryContainerService;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.common.chat.ChatBroadcaster;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;

@Singleton
public class ChatHistoryController
implements ChatHistoryService {
    private final ChatHistoryContainerService chatHistoryContainer;
    private final Provider<ChatSettings> chatSettings;
    private final ChatBroadcaster chatBroadcaster;

    @Inject
    public ChatHistoryController(ChatHistoryContainerService chatHistoryContainer, Provider<ChatSettings> chatSettings, ChatBroadcaster chatBroadcaster, PlatformInteractor interactor) {
        this.chatHistoryContainer = chatHistoryContainer;
        this.chatSettings = chatSettings;
        this.chatBroadcaster = chatBroadcaster;
    }

    @Override
    public boolean removeMessage(int id) {
        boolean removed = this.chatHistoryContainer.removeMessage(id);
        if (removed) {
            this.sendChatHistory();
        }
        return removed;
    }

    @Override
    public int removeMessages(int amount) {
        int count = this.chatHistoryContainer.removeMessages(amount);
        if (count > 0) {
            this.sendChatHistory();
        }
        return count;
    }

    @Override
    public int removeMessages(String username) {
        List<FormattedChatMessage> messages = this.chatHistoryContainer.getMessages(username);
        int count = messages.size();
        messages.forEach(message -> this.chatHistoryContainer.removeMessage(message.getId()));
        if (count > 0) {
            this.sendChatHistory();
        }
        return count;
    }

    private void sendChatHistory() {
        TextComponent filler = Component.empty();
        for (int i = 0; i < ((ChatSettings)this.chatSettings.get()).getHistory().getFillerSize(); ++i) {
            filler = filler.append((Component)Component.newline());
        }
        TextComponent finalFiller = filler;
        this.chatHistoryContainer.getMessages().forEach(arg_0 -> this.lambda$sendChatHistory$1((Component)finalFiller, arg_0));
    }

    private /* synthetic */ void lambda$sendChatHistory$1(Component finalFiller, FormattedChatMessage m) {
        m.getSender().sendMessage(finalFiller);
        this.chatBroadcaster.broadcast(m);
    }
}

