/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.chat.processor;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import lombok.Generated;
import me.whereareiam.socialismus.api.input.WorkerProcessor;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ChatMessageProcessor
implements WorkerProcessor<ChatMessage> {
    private final LinkedList<Worker<ChatMessage>> workers = new LinkedList();

    public ChatMessage process(ChatMessage chatMessage) {
        Worker worker;
        Iterator iterator = this.workers.iterator();
        while (iterator.hasNext() && !(chatMessage = (ChatMessage)(worker = (Worker)iterator.next()).getFunction().apply(chatMessage)).isCancelled()) {
        }
        return chatMessage;
    }

    @Override
    public void addWorker(Worker<ChatMessage> worker) {
        if (this.workers.stream().noneMatch(w -> w.getPriority() == worker.getPriority())) {
            this.workers.add(worker);
            this.workers.sort(Comparator.comparingInt(Worker::getPriority));
        }
    }

    @Override
    public boolean removeWorker(Worker<ChatMessage> worker) {
        if (!worker.isRemovable()) {
            return false;
        }
        return this.workers.remove(worker);
    }

    @Override
    @Generated
    public LinkedList<Worker<ChatMessage>> getWorkers() {
        return this.workers;
    }
}

