/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.container;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.container.ChatContainerService;
import me.whereareiam.socialismus.api.input.event.chat.ChatAddedEvent;
import me.whereareiam.socialismus.api.input.event.chat.ChatUpdatedEvent;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.chat.Chat;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.chat.InternalChat;
import me.whereareiam.socialismus.api.type.chat.ChatType;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class ChatContainer
implements ChatContainerService,
Reloadable {
    private final Provider<ChatSettings> chatSettings;
    private final Provider<List<Chat>> chatsProvider;
    private final ConcurrentHashMap<String, InternalChat> chats = new ConcurrentHashMap();

    @Inject
    public ChatContainer(@Named(value="chats") Provider<List<Chat>> chatsProvider, Provider<ChatSettings> chatSettings, Registry<Reloadable> registry) {
        this.chatsProvider = chatsProvider;
        this.chatSettings = chatSettings;
        registry.register(this);
        ((List)chatsProvider.get()).forEach(this::addChat);
    }

    @Override
    public void addChat(InternalChat chat) {
        if (chat.getId() == null || chat.getId().isEmpty()) {
            Logger.debug("Chat " + chat.getId() + " has no id", new Object[0]);
            return;
        }
        if (this.chats.containsKey(chat.getId())) {
            Logger.debug("Chat " + chat.getId() + " already exists, but was tried to be added again", new Object[0]);
            return;
        }
        EventUtil.callEvent(new ChatAddedEvent(chat, false), () -> this.chats.put(chat.getId(), chat));
    }

    @Override
    public void addChat(Chat chat) {
        this.addChat(InternalChat.from(chat));
    }

    @Override
    public void updateChat(String id, Chat chat) {
        EventUtil.callEvent(new ChatUpdatedEvent(this.chats.get(id), chat, false), () -> this.chats.put(chat.getId(), InternalChat.from(chat)));
    }

    @Override
    public boolean hasChat(String id) {
        return this.chats.containsKey(id);
    }

    @Override
    public boolean hasChatBySymbol(String symbol) {
        return this.chats.values().stream().filter(chat -> !chat.getParameters().getType().equals((Object)ChatType.CUSTOM)).anyMatch(chat -> symbol.isEmpty() && chat.getParameters().getSymbol().isEmpty() || chat.getParameters().getSymbol().equals(symbol));
    }

    @Override
    public Optional<InternalChat> getChat(String id) {
        return this.chats.get(id) == null ? Optional.empty() : Optional.of(this.chats.get(id));
    }

    @Override
    public List<InternalChat> getChatBySymbol(String symbol) {
        return this.chats.values().stream().filter(chat -> !chat.getParameters().getType().equals((Object)ChatType.CUSTOM)).filter(chat -> !chat.getId().equals(((ChatSettings)this.chatSettings.get()).getFallback().getChatId())).filter(chat -> symbol.isEmpty() && chat.getParameters().getSymbol().isEmpty() || chat.getParameters().getSymbol().equals(symbol)).sorted(Comparator.comparingInt(Chat::getPriority).reversed()).toList();
    }

    @Override
    public Set<InternalChat> getChats() {
        return new HashSet<InternalChat>(this.chats.values());
    }

    @Override
    public void reload() {
        this.chats.clear();
        ((List)this.chatsProvider.get()).forEach(this::addChat);
    }
}

