/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.requirement;

import java.util.Map;
import lombok.Generated;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.input.requirement.RequirementEvaluatorService;
import me.whereareiam.socialismus.api.input.requirement.RequirementValidation;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.requirement.Requirement;
import me.whereareiam.socialismus.api.model.requirement.RequirementGroup;
import me.whereareiam.socialismus.api.type.requirement.RequirementOperatorType;
import me.whereareiam.socialismus.api.type.requirement.RequirementType;
import me.whereareiam.socialismus.common.requirement.RequirementRegistry;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class RequirementEvaluator
implements RequirementEvaluatorService {
    private final RequirementRegistry requirementRegistry;

    private boolean isRequirementMet(Map.Entry<RequirementType, ? extends Requirement> entry, DummyPlayer dummyPlayer) {
        RequirementValidation checker = this.requirementRegistry.get(entry.getKey());
        if (checker == null) {
            return false;
        }
        return checker.check(entry.getValue(), dummyPlayer);
    }

    @Override
    public boolean check(RequirementGroup group, DummyPlayer dummyPlayer) {
        if (group == null || group.getGroups().isEmpty()) {
            return true;
        }
        return switch (group.getOperator()) {
            default -> throw new IncompatibleClassChangeError();
            case RequirementOperatorType.AND -> this.checkAnd(group, dummyPlayer);
            case RequirementOperatorType.OR -> this.checkOr(group, dummyPlayer);
            case RequirementOperatorType.XOR -> this.checkXor(group, dummyPlayer);
            case RequirementOperatorType.NOT -> this.checkNot(group, dummyPlayer);
            case RequirementOperatorType.NAND -> this.checkNand(group, dummyPlayer);
            case RequirementOperatorType.NOR -> this.checkNor(group, dummyPlayer);
        };
    }

    private boolean checkAnd(RequirementGroup group, DummyPlayer dummyPlayer) {
        Logger.debug("Checking AND group for player " + dummyPlayer.getUsername(), new Object[0]);
        for (Map.Entry<RequirementType, ? extends Requirement> entry : group.getGroups().entrySet()) {
            if (this.isRequirementMet(entry, dummyPlayer)) continue;
            return false;
        }
        return true;
    }

    private boolean checkOr(RequirementGroup group, DummyPlayer dummyPlayer) {
        Logger.debug("Checking OR group for player " + dummyPlayer.getUsername(), new Object[0]);
        for (Map.Entry<RequirementType, ? extends Requirement> entry : group.getGroups().entrySet()) {
            if (!this.isRequirementMet(entry, dummyPlayer)) continue;
            return true;
        }
        return false;
    }

    private boolean checkXor(RequirementGroup group, DummyPlayer dummyPlayer) {
        boolean oneMet = false;
        Logger.debug("Checking XOR group for player " + dummyPlayer.getUsername(), new Object[0]);
        for (Map.Entry<RequirementType, ? extends Requirement> entry : group.getGroups().entrySet()) {
            if (!this.isRequirementMet(entry, dummyPlayer)) continue;
            if (oneMet) {
                return false;
            }
            oneMet = true;
        }
        return oneMet;
    }

    private boolean checkNot(RequirementGroup group, DummyPlayer dummyPlayer) {
        Logger.debug("Checking NOT group for player " + dummyPlayer.getUsername(), new Object[0]);
        for (Map.Entry<RequirementType, ? extends Requirement> entry : group.getGroups().entrySet()) {
            if (!this.isRequirementMet(entry, dummyPlayer)) continue;
            return false;
        }
        return true;
    }

    private boolean checkNand(RequirementGroup group, DummyPlayer dummyPlayer) {
        return !this.checkAnd(group, dummyPlayer);
    }

    private boolean checkNor(RequirementGroup group, DummyPlayer dummyPlayer) {
        return !this.checkOr(group, dummyPlayer);
    }

    @Inject
    @Generated
    public RequirementEvaluator(RequirementRegistry requirementRegistry) {
        this.requirementRegistry = requirementRegistry;
    }
}

