/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.serializer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import me.whereareiam.socialismus.api.input.serializer.SerializationService;
import me.whereareiam.socialismus.api.input.serializer.SerializationWorker;
import me.whereareiam.socialismus.api.model.Worker;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.model.serializer.SerializerContent;
import me.whereareiam.socialismus.api.model.serializer.SerializerPlaceholder;
import me.whereareiam.socialismus.api.output.integration.FormattingIntegration;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.type.SerializationType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import net.kyori.adventure.text.Component;

@Singleton
public class Serializer
implements SerializationService,
SerializationWorker {
    private final Provider<Messages> messages;
    private final SerializationType serializationType;
    private final LinkedList<Worker<SerializerContent>> workers = new LinkedList();
    private final Provider<Set<Integration>> integrations;

    @Inject
    public Serializer(Provider<Messages> messages, Provider<Settings> settings, Provider<Set<Integration>> integrations) {
        this.messages = messages;
        this.serializationType = ((Settings)settings.get()).getSerializer();
        this.integrations = integrations;
    }

    @Override
    public Component format(DummyPlayer dummyPlayer, String message) {
        return this.format(new SerializerContent(dummyPlayer, new ArrayList<SerializerPlaceholder>(), message));
    }

    @Override
    public Component format(SerializerContent content) {
        if (content.getMessage().isEmpty()) {
            return Component.empty();
        }
        content.setMessage(content.getMessage().replace("{prefix}", ((Messages)this.messages.get()).getPrefix()));
        if (content.getDummyPlayer().getUsername() != null) {
            content.setMessage(content.getMessage().replace("{playerName}", content.getDummyPlayer().getUsername()));
        }
        content.setMessage(this.hookIntegrations(content));
        for (SerializerPlaceholder serializerPlaceholder : content.getPlaceholders()) {
            content.setMessage(content.getMessage().replace(serializerPlaceholder.getPlaceholder(), serializerPlaceholder.getValue()));
        }
        for (Worker worker : this.workers) {
            content = (SerializerContent)worker.getFunction().apply(content);
        }
        return this.serializationType.getSerializer().deserialize((Object)content.getMessage());
    }

    private String hookIntegrations(SerializerContent content) {
        List<FormattingIntegration> formatters = ((Set)this.integrations.get()).stream().filter(integration -> integration instanceof FormattingIntegration).map(integration -> (FormattingIntegration)integration).toList();
        for (FormattingIntegration formatter : formatters) {
            if (!formatter.isAvailable()) continue;
            content.setMessage(formatter.format(content.getDummyPlayer(), content.getMessage()));
        }
        return content.getMessage();
    }

    @Override
    public boolean removeWorker(Worker<SerializerContent> worker) {
        if (!worker.isRemovable()) {
            return false;
        }
        this.workers.remove(worker);
        return true;
    }

    @Override
    public void addWorker(Worker<SerializerContent> worker) {
        if (this.workers.stream().anyMatch(w -> w.getPriority() == worker.getPriority())) {
            return;
        }
        this.workers.add(worker);
        this.workers.sort((a, b) -> Integer.compare(b.getPriority(), a.getPriority()));
    }

    @Override
    @Generated
    public LinkedList<Worker<SerializerContent>> getWorkers() {
        return this.workers;
    }
}

