/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.output.integration.SynchronizationIntegration;
import me.whereareiam.socialismus.api.type.Version;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class AbstractPlatformInteractor
implements PlatformInteractor {
    private final Provider<Set<Integration>> integrations;

    @Override
    public boolean areWithinRange(UUID player1, UUID player2, double range) {
        Optional<SynchronizationIntegration> syncIntegration;
        if (((Set)this.integrations.get()).stream().anyMatch(i -> i instanceof SynchronizationIntegration) && (syncIntegration = ((Set)this.integrations.get()).stream().filter(i -> i instanceof SynchronizationIntegration).map(i -> (SynchronizationIntegration)i).findFirst()).isPresent()) {
            Optional<String> location1 = syncIntegration.get().getLocation(player1);
            Optional<String> location2 = syncIntegration.get().getLocation(player2);
            if (location1.isPresent() && location2.isPresent()) {
                return location1.get().equals(location2.get());
            }
        }
        Player p1 = Bukkit.getPlayer((UUID)player1);
        Player p2 = Bukkit.getPlayer((UUID)player2);
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.getLocation().distanceSquared(p2.getLocation()) <= range * range;
    }

    @Override
    public boolean hasPermission(String username, String permission) {
        Player player = Bukkit.getPlayer((String)username);
        if (player == null) {
            return false;
        }
        return player.hasPermission(permission);
    }

    @Override
    public boolean hasPermission(DummyPlayer dummyPlayer, String permission) {
        Player player = Bukkit.getPlayer((UUID)dummyPlayer.getUniqueId());
        if (player == null) {
            return false;
        }
        return player.hasPermission(permission);
    }

    @Override
    public int getOnlinePlayersCount() {
        return Bukkit.getOnlinePlayers().size();
    }

    @Override
    public Version getServerVersion() {
        return Version.of(Bukkit.getVersion());
    }

    @Inject
    @Generated
    public AbstractPlatformInteractor(Provider<Set<Integration>> integrations) {
        this.integrations = integrations;
    }
}

