/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.paper;

import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.command.management.CommandExceptionHandler;
import me.whereareiam.socialismus.command.provider.CommandManagerProvider;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.paper.mapper.CommandSenderMapper;
import me.whereareiam.socialismus.platform.paper.mapper.CommandSourceStackMapper;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.paper.PaperCommandManager;

@Singleton
public class PaperCommandManagerProvider
extends CommandManagerProvider {
    private final Plugin plugin;
    private final CommandSenderMapper commandSenderMapper;
    private final CommandSourceStackMapper commandSourceStackMapper;

    @Inject
    public PaperCommandManagerProvider(CommandExceptionHandler exceptionHandler, Provider<Settings> settings, Plugin plugin, PlatformInteractor interactor, CommandSenderMapper commandSenderMapper, CommandSourceStackMapper commandSourceStackMapper) {
        super(exceptionHandler, settings, interactor);
        this.plugin = plugin;
        this.commandSenderMapper = commandSenderMapper;
        this.commandSourceStackMapper = commandSourceStackMapper;
    }

    @Override
    protected CommandManager<DummyPlayer> createLegacyPaperCommandManager() {
        LegacyPaperCommandManager commandManager = new LegacyPaperCommandManager(this.plugin, ExecutionCoordinator.asyncCoordinator(), (SenderMapper)this.commandSenderMapper);
        if (commandManager.hasCapability((CloudCapability)CloudBukkitCapabilities.NATIVE_BRIGADIER) && ((Settings)this.settings.get()).getMisc().isAllowBrigadierCommands()) {
            commandManager.registerBrigadier();
        }
        if (commandManager.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            commandManager.registerAsynchronousCompletions();
        }
        return commandManager;
    }

    @Override
    protected CommandManager<DummyPlayer> createPaperCommandManager() {
        return PaperCommandManager.builder((SenderMapper)this.commandSourceStackMapper).executionCoordinator(ExecutionCoordinator.asyncCoordinator()).buildOnEnable(this.plugin);
    }

    @Override
    protected CommandManager<DummyPlayer> createVelocityCommandManager() {
        throw new UnsupportedOperationException("VelocityCommandManager is not supported on Paper");
    }
}

