/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.paper;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@Singleton
public class PaperScheduler
implements Scheduler {
    private final Plugin plugin;
    private final Map<String, Map<Integer, ScheduledTask>> tasks = new HashMap<String, Map<Integer, ScheduledTask>>();

    @Inject
    public PaperScheduler(Plugin plugin) {
        this.plugin = plugin;
        this.checkAsyncSchedulerAvailability();
    }

    private void checkAsyncSchedulerAvailability() {
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.AsyncScheduler");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AsyncScheduler not found. Please use Paper version 1.20 or newer.");
        }
    }

    @Override
    public void schedule(RunnableTask runnableTask) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runNow(this.plugin, t -> runnableTask.getRunnable().run());
        this.tasks.put(runnableTask.getModule(), Map.of(runnableTask.getId(), task));
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runDelayed(this.plugin, t -> runnableTask.getRunnable().run(), runnableTask.getDelay(), TimeUnit.MILLISECONDS);
        this.tasks.put(runnableTask.getModule(), Map.of(runnableTask.getId(), task));
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask) {
        ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(this.plugin, t -> runnableTask.getRunnable().run(), runnableTask.getDelay(), runnableTask.getPeriod(), TimeUnit.MILLISECONDS);
        this.tasks.put(runnableTask.getModule(), Map.of(runnableTask.getId(), task));
    }

    @Override
    public void schedule(RunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask, boolean async) {
        this.schedule(runnableTask);
    }

    @Override
    public void cancel(RunnableTask runnableTask) {
        if (this.tasks.containsKey(runnableTask.getModule()) && this.tasks.get(runnableTask.getModule()).containsKey(runnableTask.getId())) {
            this.tasks.get(runnableTask.getModule()).get(runnableTask.getId()).cancel();
            this.tasks.get(runnableTask.getModule()).remove(runnableTask.getId());
        }
    }

    @Override
    public void cancel(DelayedRunnableTask runnableTask) {
        this.cancel((RunnableTask)runnableTask);
    }

    @Override
    public void cancelByModule(String module) {
        if (this.tasks.containsKey(module)) {
            this.tasks.get(module).values().forEach(ScheduledTask::cancel);
            this.tasks.remove(module);
        }
    }
}

