/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.config.provider;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import me.whereareiam.socialismus.adapter.config.management.ConfigLoader;
import me.whereareiam.socialismus.api.Reloadable;
import me.whereareiam.socialismus.api.input.registry.Registry;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.config.Commands;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class CommandsProvider
implements Provider<Map<String, CommandEntity>>,
Registry<Map<String, CommandEntity>>,
Reloadable {
    private final Path dataPath;
    private final ConfigLoader configLoader;
    private Map<String, CommandEntity> commands;

    @Inject
    public CommandsProvider(@Named(value="dataPath") Path dataPath, ConfigLoader configLoader, Registry<Reloadable> registry) {
        this.dataPath = dataPath;
        this.configLoader = configLoader;
        registry.register(this);
    }

    public Map<String, CommandEntity> get() {
        if (this.commands != null) {
            return this.commands;
        }
        this.load();
        return this.commands;
    }

    @Override
    public void reload() {
        this.load();
    }

    private void load() {
        this.commands = new HashMap<String, CommandEntity>(this.configLoader.load(this.dataPath.resolve("commands"), Commands.class).getCommands());
    }

    @Override
    public void register(Map<String, CommandEntity> commands) {
        this.commands.put(commands.keySet().iterator().next(), commands.values().iterator().next());
    }
}

