/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.adapter.module.resolver;

import java.util.Set;
import java.util.regex.Pattern;
import me.whereareiam.socialismus.adapter.module.resolver.ModuleResolver;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.model.module.InternalModule;
import me.whereareiam.socialismus.api.model.module.ModuleDependency;
import me.whereareiam.socialismus.api.output.integration.Integration;
import me.whereareiam.socialismus.api.output.module.ModuleService;
import me.whereareiam.socialismus.api.type.module.DependencyType;
import me.whereareiam.socialismus.api.type.module.ModuleState;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ModuleDependencyResolver
implements ModuleResolver {
    private final ModuleService moduleService;
    private final Provider<Set<Integration>> integrations;

    @Inject
    public ModuleDependencyResolver(ModuleService moduleService, Provider<Set<Integration>> integrations) {
        this.moduleService = moduleService;
        this.integrations = integrations;
    }

    @Override
    public boolean resolve(InternalModule module) {
        if (module.getDependencies().isEmpty()) {
            return true;
        }
        for (ModuleDependency dependency : module.getDependencies()) {
            DependencyType type = dependency.getType();
            String name = dependency.getName();
            String version = dependency.getVersion();
            switch (type) {
                case INTEGRATION: {
                    if (this.isIntegrationAvailable(name)) break;
                    Logger.warn("Module %s requires integration %s, which is not available", module.getName(), name);
                    return false;
                }
                case MODULE: {
                    if (this.isModuleAvailable(name, version)) break;
                    Logger.warn("Module %s requires module %s with version %s, which is not available", module.getName(), name, version);
                    return false;
                }
                case BASE: {
                    if (this.isBaseVersionCompatible(version)) break;
                    Logger.warn("Module %s requires version of the plugin to be %s, but it is %s", module.getName(), version, "DEV");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isIntegrationAvailable(String name) {
        return ((Set)this.integrations.get()).stream().anyMatch(integration -> integration.getName().equals(name));
    }

    private boolean isModuleAvailable(String name, String version) {
        Pattern versionPattern = Pattern.compile(version);
        return this.moduleService.getModules().stream().anyMatch(module -> module.getName().equals(name) && versionPattern.matcher(module.getVersion()).matches() && module.getState() != ModuleState.ERROR);
    }

    private boolean isBaseVersionCompatible(String version) {
        Pattern versionPattern = Pattern.compile(version);
        return versionPattern.matcher("DEV").matches();
    }
}

