/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.api.model.chat.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.chat.Chat;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.util.ComponentUtil;
import net.kyori.adventure.text.Component;

public class ChatMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final DummyPlayer sender;
    private Set<DummyPlayer> recipients;
    private transient Component content;
    private Chat chat;
    private boolean cancelled;
    private boolean vanillaSending;

    public static String serialize(ChatMessage chatMessage) throws IOException {
        Object tempChatMessage = chatMessage.toBuilder().build();
        ((ChatMessage)tempChatMessage).setRecipients(Collections.emptySet());
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(tempChatMessage);
                string = Base64.getEncoder().encodeToString(bos.toByteArray());
            }
            return string;
        }
    }

    public static ChatMessage deserialize(String content) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(Base64.getDecoder().decode(content));){
            ChatMessage chatMessage;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                chatMessage = (ChatMessage)in.readObject();
            }
            return chatMessage;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(ComponentUtil.toString(this.content));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.content = ComponentUtil.toGson(in.readUTF());
    }

    @Generated
    protected ChatMessage(ChatMessageBuilder<?, ?> b) {
        this.id = b.id;
        this.sender = b.sender;
        this.recipients = b.recipients;
        this.content = b.content;
        this.chat = b.chat;
        this.cancelled = b.cancelled;
        this.vanillaSending = b.vanillaSending;
    }

    @Generated
    public static ChatMessageBuilder<?, ?> builder() {
        return new ChatMessageBuilderImpl();
    }

    @Generated
    public ChatMessageBuilder<?, ?> toBuilder() {
        return new ChatMessageBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public DummyPlayer getSender() {
        return this.sender;
    }

    @Generated
    public Set<DummyPlayer> getRecipients() {
        return this.recipients;
    }

    @Generated
    public Component getContent() {
        return this.content;
    }

    @Generated
    public Chat getChat() {
        return this.chat;
    }

    @Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Generated
    public boolean isVanillaSending() {
        return this.vanillaSending;
    }

    @Generated
    public void setRecipients(Set<DummyPlayer> recipients) {
        this.recipients = recipients;
    }

    @Generated
    public void setContent(Component content) {
        this.content = content;
    }

    @Generated
    public void setChat(Chat chat) {
        this.chat = chat;
    }

    @Generated
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Generated
    public void setVanillaSending(boolean vanillaSending) {
        this.vanillaSending = vanillaSending;
    }

    @Generated
    public String toString() {
        return "ChatMessage(id=" + this.getId() + ", sender=" + String.valueOf(this.getSender()) + ", recipients=" + String.valueOf(this.getRecipients()) + ", content=" + String.valueOf(this.getContent()) + ", chat=" + String.valueOf(this.getChat()) + ", cancelled=" + this.isCancelled() + ", vanillaSending=" + this.isVanillaSending() + ")";
    }

    @Generated
    public static abstract class ChatMessageBuilder<C extends ChatMessage, B extends ChatMessageBuilder<C, B>> {
        @Generated
        private int id;
        @Generated
        private DummyPlayer sender;
        @Generated
        private Set<DummyPlayer> recipients;
        @Generated
        private Component content;
        @Generated
        private Chat chat;
        @Generated
        private boolean cancelled;
        @Generated
        private boolean vanillaSending;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ChatMessageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ChatMessage instance, ChatMessageBuilder<?, ?> b) {
            b.id(instance.id);
            b.sender(instance.sender);
            b.recipients(instance.recipients);
            b.content(instance.content);
            b.chat(instance.chat);
            b.cancelled(instance.cancelled);
            b.vanillaSending(instance.vanillaSending);
        }

        @Generated
        public B id(int id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B sender(DummyPlayer sender) {
            this.sender = sender;
            return this.self();
        }

        @Generated
        public B recipients(Set<DummyPlayer> recipients) {
            this.recipients = recipients;
            return this.self();
        }

        @Generated
        public B content(Component content) {
            this.content = content;
            return this.self();
        }

        @Generated
        public B chat(Chat chat) {
            this.chat = chat;
            return this.self();
        }

        @Generated
        public B cancelled(boolean cancelled) {
            this.cancelled = cancelled;
            return this.self();
        }

        @Generated
        public B vanillaSending(boolean vanillaSending) {
            this.vanillaSending = vanillaSending;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ChatMessage.ChatMessageBuilder(id=" + this.id + ", sender=" + String.valueOf(this.sender) + ", recipients=" + String.valueOf(this.recipients) + ", content=" + String.valueOf(this.content) + ", chat=" + String.valueOf(this.chat) + ", cancelled=" + this.cancelled + ", vanillaSending=" + this.vanillaSending + ")";
        }
    }

    @Generated
    private static final class ChatMessageBuilderImpl
    extends ChatMessageBuilder<ChatMessage, ChatMessageBuilderImpl> {
        @Generated
        private ChatMessageBuilderImpl() {
        }

        @Override
        @Generated
        protected ChatMessageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ChatMessage build() {
            return new ChatMessage(this);
        }
    }
}

