/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.command.executor;

import java.util.Map;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.chat.ChatHistoryService;
import me.whereareiam.socialismus.api.input.container.ChatHistoryContainerService;
import me.whereareiam.socialismus.api.model.CommandEntity;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.model.config.message.Messages;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.PlatformInteractor;
import me.whereareiam.socialismus.api.output.command.CommandBase;
import me.whereareiam.socialismus.api.output.command.CommandCooldown;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Permission;

@Singleton
public class ClearCommand
extends CommandBase {
    private static final String COMMAND_NAME = "clear";
    private final Provider<Map<String, CommandEntity>> commands;
    private final Provider<Messages> messages;
    private final Provider<ChatSettings> chatSettings;
    private final ChatHistoryService chatHistory;
    private final ChatHistoryContainerService containerService;
    private final PlatformInteractor interactor;

    @Inject
    public ClearCommand(Provider<Map<String, CommandEntity>> commands, Provider<Messages> messages, Provider<ChatSettings> chatSettings, ChatHistoryService chatHistory, ChatHistoryContainerService containerService, PlatformInteractor interactor) {
        super(COMMAND_NAME);
        this.commands = commands;
        this.messages = messages;
        this.chatSettings = chatSettings;
        this.chatHistory = chatHistory;
        this.containerService = containerService;
        this.interactor = interactor;
    }

    @Command(value="%command.clear")
    @CommandDescription(value="%description.clear")
    @CommandCooldown(value="%cooldown.clear")
    @Permission(value={"%permission.clear"})
    public void onCommand(DummyPlayer dummyPlayer, @Argument(value="context") String context) {
        if (context == null) {
            this.handleNumericContext(dummyPlayer, ((ChatSettings)this.chatSettings.get()).getHistory().getHistorySize());
            return;
        }
        try {
            this.handleCommand(dummyPlayer, context);
        }
        catch (NumberFormatException e) {
            this.handleNonNumericContext(dummyPlayer, context);
        }
    }

    private void handleCommand(DummyPlayer dummyPlayer, String context) {
        try {
            int number = Integer.parseInt(context);
            if (number >= 1 && number <= ((ChatSettings)this.chatSettings.get()).getHistory().getHistorySize()) {
                this.handleNumericContext(dummyPlayer, number);
                return;
            }
            this.handleInvalidNumber(dummyPlayer, number);
        }
        catch (NumberFormatException e) {
            this.handleNonNumericContext(dummyPlayer, context);
        }
    }

    private void handleNumericContext(DummyPlayer dummyPlayer, int number) {
        if (this.hasMinimumMessages()) {
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, ((Messages)this.messages.get()).getCommands().getClearCommand().getNotEnoughHistory()));
            return;
        }
        int count = this.chatHistory.removeMessages(number);
        this.sendResponse(dummyPlayer, count, ((Messages)this.messages.get()).getCommands().getClearCommand().getClearedAmount(), ((Messages)this.messages.get()).getCommands().getClearCommand().getNoHistory());
    }

    private void handleInvalidNumber(DummyPlayer dummyPlayer, int number) {
        if (this.hasMinimumMessages()) {
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, ((Messages)this.messages.get()).getCommands().getClearCommand().getNotEnoughHistory()));
            return;
        }
        boolean removed = this.chatHistory.removeMessage(number);
        this.sendResponse(dummyPlayer, removed, ((Messages)this.messages.get()).getCommands().getClearCommand().getCleared(), ((Messages)this.messages.get()).getCommands().getClearCommand().getNoIdHistory().replace("{id}", String.valueOf(number)));
    }

    private void handleNonNumericContext(DummyPlayer dummyPlayer, String context) {
        if (this.hasMinimumMessages()) {
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, ((Messages)this.messages.get()).getCommands().getClearCommand().getNotEnoughHistory()));
            return;
        }
        if (this.interactor.hasPermission(context, ((ChatSettings)this.chatSettings.get()).getHistory().getBypassPermission())) {
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, ((Messages)this.messages.get()).getCommands().getClearCommand().getBypassUser()));
            return;
        }
        int count = this.chatHistory.removeMessages(context);
        this.sendResponse(dummyPlayer, count, ((Messages)this.messages.get()).getCommands().getClearCommand().getClearedAmount(), ((Messages)this.messages.get()).getCommands().getClearCommand().getNoUserHistory());
    }

    private boolean hasMinimumMessages() {
        return this.containerService.getMessages().size() < 5;
    }

    private void sendResponse(DummyPlayer dummyPlayer, int count, String successMessage, String failureMessage) {
        if (count > 0) {
            Logger.info("Deleted %s messages from chat history by %s", count, dummyPlayer.getUsername());
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, successMessage.replace("{amount}", String.valueOf(count))));
        } else {
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, failureMessage));
        }
    }

    private void sendResponse(DummyPlayer dummyPlayer, boolean removed, String successMessage, String failureMessage) {
        if (removed) {
            Logger.info("Deleted message from chat history by %s", dummyPlayer.getUsername());
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, successMessage));
        } else {
            dummyPlayer.sendMessage(Serializer.serialize(dummyPlayer, failureMessage));
        }
    }

    @Override
    public CommandEntity getCommandEntity() {
        return (CommandEntity)((Map)this.commands.get()).get(COMMAND_NAME);
    }
}

