/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common;

import java.util.ArrayList;
import me.whereareiam.socialismus.api.AnsiColor;
import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.Serializer;
import me.whereareiam.socialismus.api.input.event.plugin.PluginInitializedEvent;
import me.whereareiam.socialismus.api.input.serializer.SerializationService;
import me.whereareiam.socialismus.api.model.chat.ChatMessages;
import me.whereareiam.socialismus.api.model.chat.ChatSettings;
import me.whereareiam.socialismus.api.output.LoggingHelper;
import me.whereareiam.socialismus.api.output.command.CommandService;
import me.whereareiam.socialismus.api.output.listener.ListenerRegistrar;
import me.whereareiam.socialismus.api.output.module.ModuleService;
import me.whereareiam.socialismus.api.type.PlatformType;
import me.whereareiam.socialismus.api.type.PluginType;
import me.whereareiam.socialismus.api.util.EventUtil;
import me.whereareiam.socialismus.common.CommonInjector;
import me.whereareiam.socialismus.common.Updater;
import me.whereareiam.socialismus.common.chat.worker.FormatSelector;
import me.whereareiam.socialismus.common.chat.worker.chatmessage.ChatSelector;
import me.whereareiam.socialismus.common.chat.worker.chatmessage.RecipientResolver;
import me.whereareiam.socialismus.common.chat.worker.chatmessage.RecipientSelector;
import me.whereareiam.socialismus.common.container.ChatContainer;
import me.whereareiam.socialismus.common.provider.IntegrationProvider;
import me.whereareiam.socialismus.library.guice.Injector;

public class CommonSocialismus {
    private Injector injector;

    public void onEnable() {
        this.injector = CommonInjector.getInjector();
        Logger.init((LoggingHelper)this.injector.getInstance(LoggingHelper.class));
        Serializer.init((SerializationService)this.injector.getInstance(SerializationService.class));
        this.injector.getInstance(ChatContainer.class);
        this.injector.getInstance(RecipientResolver.class);
        this.injector.getInstance(ChatSelector.class);
        this.injector.getInstance(RecipientSelector.class);
        this.injector.getInstance(FormatSelector.class);
        this.injector.getInstance(ChatMessages.class);
        this.injector.getInstance(ChatSettings.class);
        ((CommandService)this.injector.getInstance(CommandService.class)).registerCommands();
        ((ListenerRegistrar)this.injector.getInstance(ListenerRegistrar.class)).registerListeners();
        this.printWelcomeMessage();
        ((Updater)this.injector.getInstance(Updater.class)).start();
        ((ModuleService)this.injector.getInstance(ModuleService.class)).loadModules();
        EventUtil.callEvent(new PluginInitializedEvent(), () -> {});
    }

    public void onDisable() {
    }

    private void printWelcomeMessage() {
        LoggingHelper loggingHelper = (LoggingHelper)this.injector.getInstance(LoggingHelper.class);
        ArrayList<Object> content = new ArrayList<Object>();
        content.add(" ");
        content.add(String.valueOf((Object)AnsiColor.CYAN) + "  \u2588\u2580\u2003\u2588\u2580\u2580   " + String.valueOf((Object)AnsiColor.RESET) + "Socialismus v" + String.valueOf((Object)AnsiColor.GRAY) + "DEV" + String.valueOf((Object)AnsiColor.RESET));
        content.add(String.valueOf((Object)AnsiColor.CYAN) + "  \u2584\u2588\u2003\u2588\u2584\u2584   " + String.valueOf((Object)AnsiColor.RESET) + "Platform: " + String.valueOf((Object)AnsiColor.GRAY) + PlatformType.getType().toString() + " [" + PluginType.getType().toString() + "]" + String.valueOf((Object)AnsiColor.RESET));
        content.add(" ");
        int commandCount = ((CommandService)this.injector.getInstance(CommandService.class)).getCommandCount();
        content.add("  Loaded " + String.valueOf((Object)AnsiColor.CYAN) + commandCount + String.valueOf((Object)AnsiColor.RESET) + " command" + (commandCount == 1 ? "" : "s"));
        int chatCount = ((ChatContainer)this.injector.getInstance(ChatContainer.class)).getChats().size();
        content.add("  Loaded " + String.valueOf((Object)AnsiColor.CYAN) + chatCount + String.valueOf((Object)AnsiColor.RESET) + " chat" + (chatCount == 1 ? "" : "s"));
        content.add(" ");
        content.add("  Integrations:");
        ((IntegrationProvider)this.injector.getInstance(IntegrationProvider.class)).get().forEach(integration -> content.add("    - " + String.valueOf((Object)AnsiColor.GREEN) + integration.getName() + String.valueOf((Object)AnsiColor.RESET)));
        content.add(" ");
        content.forEach(x$0 -> loggingHelper.info((String)x$0, new Object[0]));
    }
}

